SET foreign_key_checks = 0;

CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `added_by` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `announcements_company_id_foreign` (`company_id`),
  KEY `announcements_department_id_foreign` (`department_id`),
  CONSTRAINT `announcements_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `announcements_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `appraisals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `department_id` bigint unsigned NOT NULL,
  `designation_id` bigint unsigned NOT NULL,
  `customer_experience` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `marketing` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `administration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `professionalism` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `integrity` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attendance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `date` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `appraisals_company_id_foreign` (`company_id`),
  KEY `appraisals_employee_id_foreign` (`employee_id`),
  KEY `appraisals_department_id_foreign` (`department_id`),
  KEY `appraisals_designation_id_foreign` (`designation_id`),
  CONSTRAINT `appraisals_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appraisals_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appraisals_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appraisals_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO appraisals VALUES('1','1','9','1','2','Beginner','Beginner','Intermidiate','Advanced','None','None','In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document or a typeface without relying on meaningful content.','01/17/2021','2021-01-17 12:06:09','2021-01-17 12:13:12');
INSERT INTO appraisals VALUES('6','11','59','7','8','Advanced','Advanced','Intermidiate','Advanced','Advanced','Advanced','good','05/14/2025','2025-05-17 15:07:50','2025-05-17 15:07:50');



CREATE TABLE `asset_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `category_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO asset_categories VALUES('1','','Laptop','2020-07-29 11:45:07','2025-05-16 13:19:00');
INSERT INTO asset_categories VALUES('2','','Desktop','2025-05-16 13:18:50','2025-05-16 13:18:50');
INSERT INTO asset_categories VALUES('3','','Mobile','2025-05-16 13:19:30','2025-05-16 13:19:30');
INSERT INTO asset_categories VALUES('4','','License (Adobe Photoshop)','2025-05-16 13:21:30','2025-05-16 13:28:09');
INSERT INTO asset_categories VALUES('5','','License (Microsoft Window 10-11)','2025-05-16 13:22:27','2025-05-16 13:22:27');
INSERT INTO asset_categories VALUES('6','','License (Canva Pro)','2025-05-16 13:24:20','2025-05-16 13:24:20');
INSERT INTO asset_categories VALUES('7','','License (Adobe Acrobat )','2025-05-16 13:25:02','2025-05-16 13:27:54');
INSERT INTO asset_categories VALUES('8','','License (Adobe Premiere Pro)','2025-05-16 13:26:47','2025-05-16 13:27:38');
INSERT INTO asset_categories VALUES('9','','License (Adoble Illustrator)','2025-05-16 13:28:33','2025-05-16 13:28:33');
INSERT INTO asset_categories VALUES('10','','License (Adobe Creative Cloud All Apps)','2025-05-16 13:29:33','2025-05-16 13:29:33');
INSERT INTO asset_categories VALUES('11','','License (Adobe InDesign)','2025-05-16 13:30:20','2025-05-16 13:30:20');
INSERT INTO asset_categories VALUES('12','','License ( zoho Mail)','2025-05-16 13:31:31','2025-05-16 13:31:31');
INSERT INTO asset_categories VALUES('13','','License ( zoho CRM )','2025-05-16 13:31:43','2025-05-16 13:31:43');
INSERT INTO asset_categories VALUES('14','','License ( Whatsapp API)','2025-05-16 13:32:35','2025-05-16 13:32:35');
INSERT INTO asset_categories VALUES('15','','Sim Cards','2025-05-17 14:48:26','2025-05-17 14:48:26');
INSERT INTO asset_categories VALUES('16','','WPS Software','2025-05-17 14:49:08','2025-05-17 14:49:08');



CREATE TABLE `assets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `asset_code` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `assets_category_id` bigint unsigned NOT NULL,
  `Asset_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `manufacturer` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serial_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `warranty_date` date NOT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_company_id_foreign` (`company_id`),
  KEY `assets_employee_id_foreign` (`employee_id`),
  KEY `assets_assets_category_id_foreign` (`assets_category_id`),
  CONSTRAINT `assets_assets_category_id_foreign` FOREIGN KEY (`assets_category_id`) REFERENCES `asset_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO assets VALUES('1','Laptop','1','9','lap-01','1','','Asus','637256','Inv-090','','2020-10-25','2021-05-30','yes','2020-07-29 11:46:05','2020-07-29 11:46:05');
INSERT INTO assets VALUES('2','Laptop-007','11','59','Renew','1','&lt;p&gt;ma&lt;/p&gt;','Dell','','','','2024-02-14','2026-07-28','yes','2025-05-17 14:53:07','2025-05-17 14:53:07');
INSERT INTO assets VALUES('3','Canva Pro','11','59','','6','','Canva','','','','2025-05-14','2026-05-14','yes','2025-05-17 14:54:50','2025-05-17 14:54:50');



CREATE TABLE `attendances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `clock_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_in_ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_out_ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_in_out` tinyint NOT NULL,
  `time_late` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:00',
  `early_leaving` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:00',
  `overtime` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:00',
  `total_work` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:00',
  `total_rest` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:00',
  `attendance_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'present',
  PRIMARY KEY (`id`),
  KEY `attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO attendances VALUES('3','9','2022-06-08','10:10','::1','11:14','::1','0','00:10','05:46','00:00','01:04','00:00','present');
INSERT INTO attendances VALUES('6','11','2021-03-30','10:05','','14:05','','0','00:05','00:00','00:05','04:00','00:00','present');
INSERT INTO attendances VALUES('9','9','2022-06-07','10:25','::1','12:40','::1','0','00:25','04:20','00:40','02:15','00:11','present');
INSERT INTO attendances VALUES('10','9','2021-03-29','10:00','::1','14:00','::1','0','00:00','00:00','00:00','04:00','00:00','present');
INSERT INTO attendances VALUES('11','9','2021-03-29','10:00','::1','14:20','::1','0','00:00','00:00','00:20','04:20','00:00','present');
INSERT INTO attendances VALUES('12','9','2021-03-29','10:00','::1','13:20','::1','0','00:00','40:00','00:00','03:20','00:00','present');
INSERT INTO attendances VALUES('16','11','2021-03-29','10:00','','17:00','','0','00:00','00:00','03:00','08:00','00:00','present');
INSERT INTO attendances VALUES('17','11','2021-03-29','09:00','','15:00','','0','00:00','00:00','00:00','06:00','00:00','present');
INSERT INTO attendances VALUES('18','9','2021-03-29','11:24','127.0.0.1','11:29','127.0.0.1','0','01:24','05:30','00:00','00:05','00:00','present');
INSERT INTO attendances VALUES('19','9','2021-03-29','10:00','127.0.0.1','00:28','127.0.0.1','0','00:00','16:31','00:00','09:31','00:00','present');
INSERT INTO attendances VALUES('25','11','2021-06-30','10:00','','17:00','','0','00:00','00:00','00:00','08:00','00:00','present');
INSERT INTO attendances VALUES('26','11','2021-07-01','22:00','','17:00','','0','12:00','00:00','03:00','05:00','00:00','present');
INSERT INTO attendances VALUES('27','9','2021-07-04','20:32','::1','20:32','::1','0','00:00','00:00','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('29','9','2021-09-12','09:56','::1','10:07','::1','0','00:01','00:00','00:07','00:11','00:00','present');
INSERT INTO attendances VALUES('36','9','2021-11-13','13:31','127.0.0.1','13:40','127.0.0.1','0','04:31','03:20','00:00','00:09','00:00','present');
INSERT INTO attendances VALUES('37','9','2021-11-15','09:00','127.0.0.1','07:55','127.0.0.1','0','00:00','09:05','00:00','01:04','00:00','present');
INSERT INTO attendances VALUES('38','9','2021-11-14','09:40','154.136.171.168','19:03','154.136.171.168','0','00:40','00:00','02:03','09:23','00:00','present');
INSERT INTO attendances VALUES('39','9','2021-11-14','19:03','154.136.171.168','19:03','154.136.171.168','0','00:00','00:00','02:03','00:00','00:00','present');
INSERT INTO attendances VALUES('40','9','2021-11-14','19:03','154.136.171.168','19:03','154.136.171.168','0','00:00','00:00','02:03','00:00','00:00','present');
INSERT INTO attendances VALUES('41','9','2021-11-14','19:03','154.136.171.168','19:03','154.136.171.168','0','00:00','00:00','02:03','00:00','00:00','present');
INSERT INTO attendances VALUES('42','9','2021-11-14','19:03','154.136.171.168','19:04','154.136.171.168','0','00:00','00:00','02:04','00:01','00:00','present');
INSERT INTO attendances VALUES('60','9','2022-08-21','08:59','::1','17:11','::1','0','00:00','00:00','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('63','9','2022-09-17','18:21','::1','18:46','::1','0','00:00','00:00','00:00','00:00','01:10','present');
INSERT INTO attendances VALUES('64','9','2022-09-17','19:47','::1','20:48','::1','0','00:00','00:00','01:38','09:38','01:01','present');
INSERT INTO attendances VALUES('69','9','2022-10-02','09:16','','13:00','','0','00:16','04:00','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('70','9','2022-10-02','13:30','','18:00','','0','00:00','00:00','00:14','08:14','00:30','present');
INSERT INTO attendances VALUES('72','9','2023-09-06','10:07','127.0.0.1','10:07','127.0.0.1','0','01:07','06:53','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('73','9','2023-09-06','10:09','127.0.0.1','10:09','127.0.0.1','0','00:00','06:51','00:00','00:00','00:02','present');
INSERT INTO attendances VALUES('74','59','2025-05-16','14:09','223.190.80.55','','','1','04:09','00:00','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('75','59','2025-05-16','10:10','','18:00','','0','00:00','00:00','00:00','07:50','08:58','present');
INSERT INTO attendances VALUES('76','59','2025-05-17','12:42','223.190.80.55','','','1','02:42','00:00','00:00','00:00','00:00','present');
INSERT INTO attendances VALUES('77','59','2025-05-22','10:00','','18:00','','0','00:00','00:00','00:00','08:00','00:00','present');
INSERT INTO attendances VALUES('78','59','2025-05-21','10:00','','18:00','','0','00:00','00:00','00:00','08:00','00:00','present');



CREATE TABLE `award_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `award_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO award_types VALUES('1','Performer Of The Year','2020-07-27 01:49:34','2020-07-27 01:49:34');
INSERT INTO award_types VALUES('2','Best Salesman','2020-07-27 01:49:47','2020-07-27 01:49:47');
INSERT INTO award_types VALUES('3','Performance','2023-09-20 17:26:50','2023-09-20 17:26:50');
INSERT INTO award_types VALUES('4','Best Seller','2023-11-06 08:08:24','2023-11-06 08:08:24');



CREATE TABLE `awards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `award_information` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `award_date` date NOT NULL,
  `gift` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `award_type_id` bigint unsigned DEFAULT NULL,
  `award_photo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_department_id_foreign` (`department_id`),
  KEY `awards_employee_id_foreign` (`employee_id`),
  KEY `awards_award_type_id_foreign` (`award_type_id`),
  CONSTRAINT `awards_award_type_id_foreign` FOREIGN KEY (`award_type_id`) REFERENCES `award_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO awards VALUES('2','dfsdf','2021-03-17','watch','100','1','1','9','1','','2020-08-18 12:16:49','2020-08-18 12:16:49');



CREATE TABLE `c_m_s` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `home` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `about` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `contact` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO c_m_s VALUES('1','&lt;div class=&quot;container&quot;&gt;
&lt;p&gt;Home Page, You can add your page design here&lt;/p&gt;
&lt;/div&gt;','&lt;p&gt;About Page, You can add your page design here&lt;/p&gt;','&lt;div class=&quot;details&quot;&gt;
&lt;h3&gt;Address&lt;/h3&gt;
Bhandar Market (7th Floor), &lt;br /&gt;309, Sheikh Mujib Road &lt;br /&gt;(Opposite Chowmohoni Fire Service) &lt;br /&gt;Chittagong&lt;/div&gt;
&lt;div class=&quot;details mar-top-30&quot;&gt;
&lt;h3&gt;&amp;nbsp;&lt;/h3&gt;
&lt;p&gt;&amp;nbsp;&lt;/p&gt;
&lt;h3&gt;Email&lt;/h3&gt;
support@lion-coders.com&lt;/div&gt;','2020-07-27 14:49:39','2024-07-28 08:56:19');



CREATE TABLE `calendarables` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `candidate_interview` (
  `interview_id` bigint unsigned NOT NULL,
  `candidate_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`candidate_id`),
  KEY `candidate_interview_candidate_id_foreign` (`candidate_id`),
  CONSTRAINT `candidate_interview_candidate_id_foreign` FOREIGN KEY (`candidate_id`) REFERENCES `job_candidates` (`id`),
  CONSTRAINT `candidate_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO candidate_interview VALUES('1','3');
INSERT INTO candidate_interview VALUES('2','3');
INSERT INTO candidate_interview VALUES('3','3');



CREATE TABLE `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address1` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `address2` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` tinyint DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `clients_id_foreign` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `companies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_type_id` bigint unsigned NOT NULL DEFAULT '1',
  `trading_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` bigint unsigned DEFAULT NULL,
  `company_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_location_id_foreign` (`location_id`),
  KEY `companies_company_type_id_foreign` (`company_type_id`),
  CONSTRAINT `companies_company_type_id_foreign` FOREIGN KEY (`company_type_id`) REFERENCES `company_types` (`id`),
  CONSTRAINT `companies_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO companies VALUES('1','HR1','5','omega','5654335','54324','omega@gmail.com','hr1.com','675436','','2019008832_1595789616.png','','2020-07-27 00:23:37','2024-07-22 19:37:23');
INSERT INTO companies VALUES('11','CBSPD','8','CBS publishers and distributors Private Limited','','011','Abc@cbspd.com','www.cbspd.com','08888999-00','4','','','2025-05-15 23:49:22','2025-05-15 23:49:22');
INSERT INTO companies VALUES('12','Eduport global','8','Eduport','','00911','Varun@eduportglobal.com','Eduportglobal.com','939938838','4','','','2025-05-15 23:51:41','2025-05-15 23:51:41');



CREATE TABLE `company_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO company_types VALUES('1','Software Firm','2024-07-22 15:25:31','2025-05-22 14:34:50','2025-05-22 14:34:50');
INSERT INTO company_types VALUES('3','Test','2024-07-22 15:49:53','2024-07-22 15:51:29','2024-07-22 15:51:29');
INSERT INTO company_types VALUES('4','Test 2','2024-07-22 15:50:15','2024-07-22 15:51:34','2024-07-22 15:51:34');
INSERT INTO company_types VALUES('5','Coorporation','2024-07-22 15:52:32','2025-05-22 14:35:17','2025-05-22 14:35:17');
INSERT INTO company_types VALUES('6','Organization','2024-07-22 15:52:57','2025-05-22 14:35:26','2025-05-22 14:35:26');
INSERT INTO company_types VALUES('7','Partnership','2024-07-22 15:53:08','2025-05-22 14:35:10','2025-05-22 14:35:10');
INSERT INTO company_types VALUES('8','Private Foundation','2024-07-22 15:53:18','2024-07-22 15:53:18','');
INSERT INTO company_types VALUES('9','Limited Liability Company','2024-07-22 15:53:31','2025-05-22 14:35:02','2025-05-22 14:35:02');



CREATE TABLE `complaints` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `complaint_title` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned NOT NULL,
  `complaint_from` bigint unsigned NOT NULL,
  `complaint_against` bigint unsigned NOT NULL,
  `complaint_date` date NOT NULL,
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `complaints_company_id_foreign` (`company_id`),
  KEY `complaints_complaint_from_foreign` (`complaint_from`),
  KEY `complaints_complaint_against_foreign` (`complaint_against`),
  CONSTRAINT `complaints_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_against_foreign` FOREIGN KEY (`complaint_against`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_from_foreign` FOREIGN KEY (`complaint_from`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO countries VALUES('1','US','United States');
INSERT INTO countries VALUES('2','CA','Canada');
INSERT INTO countries VALUES('3','AF','Afghanistan');
INSERT INTO countries VALUES('4','AL','Albania');
INSERT INTO countries VALUES('5','DZ','Algeria');
INSERT INTO countries VALUES('6','DS','American Samoa');
INSERT INTO countries VALUES('7','AD','Andorra');
INSERT INTO countries VALUES('8','AO','Angola');
INSERT INTO countries VALUES('9','AI','Anguilla');
INSERT INTO countries VALUES('10','AQ','Antarctica');
INSERT INTO countries VALUES('11','AG','Antigua and/or Barbuda');
INSERT INTO countries VALUES('12','AR','Argentina');
INSERT INTO countries VALUES('13','AM','Armenia');
INSERT INTO countries VALUES('14','AW','Aruba');
INSERT INTO countries VALUES('15','AU','Australia');
INSERT INTO countries VALUES('16','AT','Austria');
INSERT INTO countries VALUES('17','AZ','Azerbaijan');
INSERT INTO countries VALUES('18','BS','Bahamas');
INSERT INTO countries VALUES('19','BH','Bahrain');
INSERT INTO countries VALUES('20','BD','Bangladesh');
INSERT INTO countries VALUES('21','BB','Barbados');
INSERT INTO countries VALUES('22','BY','Belarus');
INSERT INTO countries VALUES('23','BE','Belgium');
INSERT INTO countries VALUES('24','BZ','Belize');
INSERT INTO countries VALUES('25','BJ','Benin');
INSERT INTO countries VALUES('26','BM','Bermuda');
INSERT INTO countries VALUES('27','BT','Bhutan');
INSERT INTO countries VALUES('28','BO','Bolivia');
INSERT INTO countries VALUES('29','BA','Bosnia and Herzegovina');
INSERT INTO countries VALUES('30','BW','Botswana');
INSERT INTO countries VALUES('31','BV','Bouvet Island');
INSERT INTO countries VALUES('32','BR','Brazil');
INSERT INTO countries VALUES('33','IO','British lndian Ocean Territory');
INSERT INTO countries VALUES('34','BN','Brunei Darussalam');
INSERT INTO countries VALUES('35','BG','Bulgaria');
INSERT INTO countries VALUES('36','BF','Burkina Faso');
INSERT INTO countries VALUES('37','BI','Burundi');
INSERT INTO countries VALUES('38','KH','Cambodia');
INSERT INTO countries VALUES('39','CM','Cameroon');
INSERT INTO countries VALUES('40','CV','Cape Verde');
INSERT INTO countries VALUES('41','KY','Cayman Islands');
INSERT INTO countries VALUES('42','CF','Central African Republic');
INSERT INTO countries VALUES('43','TD','Chad');
INSERT INTO countries VALUES('44','CL','Chile');
INSERT INTO countries VALUES('45','CN','China');
INSERT INTO countries VALUES('46','CX','Christmas Island');
INSERT INTO countries VALUES('47','CC','Cocos (Keeling) Islands');
INSERT INTO countries VALUES('48','CO','Colombia');
INSERT INTO countries VALUES('49','KM','Comoros');
INSERT INTO countries VALUES('50','CG','Congo');
INSERT INTO countries VALUES('51','CK','Cook Islands');
INSERT INTO countries VALUES('52','CR','Costa Rica');
INSERT INTO countries VALUES('53','HR','Croatia (Hrvatska)');
INSERT INTO countries VALUES('54','CU','Cuba');
INSERT INTO countries VALUES('55','CY','Cyprus');
INSERT INTO countries VALUES('56','CZ','Czech Republic');
INSERT INTO countries VALUES('57','DK','Denmark');
INSERT INTO countries VALUES('58','DJ','Djibouti');
INSERT INTO countries VALUES('59','DM','Dominica');
INSERT INTO countries VALUES('60','DO','Dominican Republic');
INSERT INTO countries VALUES('61','TP','East Timor');
INSERT INTO countries VALUES('62','EC','Ecudaor');
INSERT INTO countries VALUES('63','EG','Egypt');
INSERT INTO countries VALUES('64','SV','El Salvador');
INSERT INTO countries VALUES('65','GQ','Equatorial Guinea');
INSERT INTO countries VALUES('66','ER','Eritrea');
INSERT INTO countries VALUES('67','EE','Estonia');
INSERT INTO countries VALUES('68','ET','Ethiopia');
INSERT INTO countries VALUES('69','FK','Falkland Islands (Malvinas)');
INSERT INTO countries VALUES('70','FO','Faroe Islands');
INSERT INTO countries VALUES('71','FJ','Fiji');
INSERT INTO countries VALUES('72','FI','Finland');
INSERT INTO countries VALUES('73','FR','France');
INSERT INTO countries VALUES('74','FX','France, Metropolitan');
INSERT INTO countries VALUES('75','GF','French Guiana');
INSERT INTO countries VALUES('76','PF','French Polynesia');
INSERT INTO countries VALUES('77','TF','French Southern Territories');
INSERT INTO countries VALUES('78','GA','Gabon');
INSERT INTO countries VALUES('79','GM','Gambia');
INSERT INTO countries VALUES('80','GE','Georgia');
INSERT INTO countries VALUES('81','DE','Germany');
INSERT INTO countries VALUES('82','GH','Ghana');
INSERT INTO countries VALUES('83','GI','Gibraltar');
INSERT INTO countries VALUES('84','GR','Greece');
INSERT INTO countries VALUES('85','GL','Greenland');
INSERT INTO countries VALUES('86','GD','Grenada');
INSERT INTO countries VALUES('87','GP','Guadeloupe');
INSERT INTO countries VALUES('88','GU','Guam');
INSERT INTO countries VALUES('89','GT','Guatemala');
INSERT INTO countries VALUES('90','GN','Guinea');
INSERT INTO countries VALUES('91','GW','Guinea-Bissau');
INSERT INTO countries VALUES('92','GY','Guyana');
INSERT INTO countries VALUES('93','HT','Haiti');
INSERT INTO countries VALUES('94','HM','Heard and Mc Donald Islands');
INSERT INTO countries VALUES('95','HN','Honduras');
INSERT INTO countries VALUES('96','HK','Hong Kong');
INSERT INTO countries VALUES('97','HU','Hungary');
INSERT INTO countries VALUES('98','IS','Iceland');
INSERT INTO countries VALUES('99','IN','India');
INSERT INTO countries VALUES('100','ID','Indonesia');
INSERT INTO countries VALUES('101','IR','Iran (Islamic Republic of)');
INSERT INTO countries VALUES('102','IQ','Iraq');
INSERT INTO countries VALUES('103','IE','Ireland');
INSERT INTO countries VALUES('104','IL','Israel');
INSERT INTO countries VALUES('105','IT','Italy');
INSERT INTO countries VALUES('106','CI','Ivory Coast');
INSERT INTO countries VALUES('107','JM','Jamaica');
INSERT INTO countries VALUES('108','JP','Japan');
INSERT INTO countries VALUES('109','JO','Jordan');
INSERT INTO countries VALUES('110','KZ','Kazakhstan');
INSERT INTO countries VALUES('111','KE','Kenya');
INSERT INTO countries VALUES('112','KI','Kiribati');
INSERT INTO countries VALUES('113','KP','Korea, Democratic People\'s Republic of');
INSERT INTO countries VALUES('114','KR','Korea, Republic of');
INSERT INTO countries VALUES('115','KW','Kuwait');
INSERT INTO countries VALUES('116','KG','Kyrgyzstan');
INSERT INTO countries VALUES('117','LA','Lao People\'s Democratic Republic');
INSERT INTO countries VALUES('118','LV','Latvia');
INSERT INTO countries VALUES('119','LB','Lebanon');
INSERT INTO countries VALUES('120','LS','Lesotho');
INSERT INTO countries VALUES('121','LR','Liberia');
INSERT INTO countries VALUES('122','LY','Libyan Arab Jamahiriya');
INSERT INTO countries VALUES('123','LI','Liechtenstein');
INSERT INTO countries VALUES('124','LT','Lithuania');
INSERT INTO countries VALUES('125','LU','Luxembourg');
INSERT INTO countries VALUES('126','MO','Macau');
INSERT INTO countries VALUES('127','MK','Macedonia');
INSERT INTO countries VALUES('128','MG','Madagascar');
INSERT INTO countries VALUES('129','MW','Malawi');
INSERT INTO countries VALUES('130','MY','Malaysia');
INSERT INTO countries VALUES('131','MV','Maldives');
INSERT INTO countries VALUES('132','ML','Mali');
INSERT INTO countries VALUES('133','MT','Malta');
INSERT INTO countries VALUES('134','MH','Marshall Islands');
INSERT INTO countries VALUES('135','MQ','Martinique');
INSERT INTO countries VALUES('136','MR','Mauritania');
INSERT INTO countries VALUES('137','MU','Mauritius');
INSERT INTO countries VALUES('138','TY','Mayotte');
INSERT INTO countries VALUES('139','MX','Mexico');
INSERT INTO countries VALUES('140','FM','Micronesia, Federated States of');
INSERT INTO countries VALUES('141','MD','Moldova, Republic of');
INSERT INTO countries VALUES('142','MC','Monaco');
INSERT INTO countries VALUES('143','MN','Mongolia');
INSERT INTO countries VALUES('144','MS','Montserrat');
INSERT INTO countries VALUES('145','MA','Morocco');
INSERT INTO countries VALUES('146','MZ','Mozambique');
INSERT INTO countries VALUES('147','MM','Myanmar');
INSERT INTO countries VALUES('148','NA','Namibia');
INSERT INTO countries VALUES('149','NR','Nauru');
INSERT INTO countries VALUES('150','NP','Nepal');
INSERT INTO countries VALUES('151','NL','Netherlands');
INSERT INTO countries VALUES('152','AN','Netherlands Antilles');
INSERT INTO countries VALUES('153','NC','New Caledonia');
INSERT INTO countries VALUES('154','NZ','New Zealand');
INSERT INTO countries VALUES('155','NI','Nicaragua');
INSERT INTO countries VALUES('156','NE','Niger');
INSERT INTO countries VALUES('157','NG','Nigeria');
INSERT INTO countries VALUES('158','NU','Niue');
INSERT INTO countries VALUES('159','NF','Norfork Island');
INSERT INTO countries VALUES('160','MP','Northern Mariana Islands');
INSERT INTO countries VALUES('161','NO','Norway');
INSERT INTO countries VALUES('162','OM','Oman');
INSERT INTO countries VALUES('163','PK','Pakistan');
INSERT INTO countries VALUES('164','PW','Palau');
INSERT INTO countries VALUES('165','PA','Panama');
INSERT INTO countries VALUES('166','PG','Papua New Guinea');
INSERT INTO countries VALUES('167','PY','Paraguay');
INSERT INTO countries VALUES('168','PE','Peru');
INSERT INTO countries VALUES('169','PH','Philippines');
INSERT INTO countries VALUES('170','PN','Pitcairn');
INSERT INTO countries VALUES('171','PL','Poland');
INSERT INTO countries VALUES('172','PT','Portugal');
INSERT INTO countries VALUES('173','PR','Puerto Rico');
INSERT INTO countries VALUES('174','QA','Qatar');
INSERT INTO countries VALUES('175','RE','Reunion');
INSERT INTO countries VALUES('176','RO','Romania');
INSERT INTO countries VALUES('177','RU','Russian Federation');
INSERT INTO countries VALUES('178','RW','Rwanda');
INSERT INTO countries VALUES('179','KN','Saint Kitts and Nevis');
INSERT INTO countries VALUES('180','LC','Saint Lucia');
INSERT INTO countries VALUES('181','VC','Saint Vincent and the Grenadines');
INSERT INTO countries VALUES('182','WS','Samoa');
INSERT INTO countries VALUES('183','SM','San Marino');
INSERT INTO countries VALUES('184','ST','Sao Tome and Principe');
INSERT INTO countries VALUES('185','SA','Saudi Arabia');
INSERT INTO countries VALUES('186','SN','Senegal');
INSERT INTO countries VALUES('187','SC','Seychelles');
INSERT INTO countries VALUES('188','SL','Sierra Leone');
INSERT INTO countries VALUES('189','SG','Singapore');
INSERT INTO countries VALUES('190','SK','Slovakia');
INSERT INTO countries VALUES('191','SI','Slovenia');
INSERT INTO countries VALUES('192','SB','Solomon Islands');
INSERT INTO countries VALUES('193','SO','Somalia');
INSERT INTO countries VALUES('194','ZA','South Africa');
INSERT INTO countries VALUES('195','GS','South Georgia South Sandwich Islands');
INSERT INTO countries VALUES('196','ES','Spain');
INSERT INTO countries VALUES('197','LK','Sri Lanka');
INSERT INTO countries VALUES('198','SH','St. Helena');
INSERT INTO countries VALUES('199','PM','St. Pierre and Miquelon');
INSERT INTO countries VALUES('200','SD','Sudan');
INSERT INTO countries VALUES('201','SR','Suriname');
INSERT INTO countries VALUES('202','SJ','Svalbarn and Jan Mayen Islands');
INSERT INTO countries VALUES('203','SZ','Swaziland');
INSERT INTO countries VALUES('204','SE','Sweden');
INSERT INTO countries VALUES('205','CH','Switzerland');
INSERT INTO countries VALUES('206','SY','Syrian Arab Republic');
INSERT INTO countries VALUES('207','TW','Taiwan');
INSERT INTO countries VALUES('208','TJ','Tajikistan');
INSERT INTO countries VALUES('209','TZ','Tanzania, United Republic of');
INSERT INTO countries VALUES('210','TH','Thailand');
INSERT INTO countries VALUES('211','TG','Togo');
INSERT INTO countries VALUES('212','TK','Tokelau');
INSERT INTO countries VALUES('213','TO','Tonga');
INSERT INTO countries VALUES('214','TT','Trinidad and Tobago');
INSERT INTO countries VALUES('215','TN','Tunisia');
INSERT INTO countries VALUES('216','TR','Turkey');
INSERT INTO countries VALUES('217','TM','Turkmenistan');
INSERT INTO countries VALUES('218','TC','Turks and Caicos Islands');
INSERT INTO countries VALUES('219','TV','Tuvalu');
INSERT INTO countries VALUES('220','UG','Uganda');
INSERT INTO countries VALUES('221','UA','Ukraine');
INSERT INTO countries VALUES('222','AE','United Arab Emirates');
INSERT INTO countries VALUES('223','GB','United Kingdom');
INSERT INTO countries VALUES('224','UM','United States minor outlying islands');
INSERT INTO countries VALUES('225','UY','Uruguay');
INSERT INTO countries VALUES('226','UZ','Uzbekistan');
INSERT INTO countries VALUES('227','VU','Vanuatu');
INSERT INTO countries VALUES('228','VA','Vatican City State');
INSERT INTO countries VALUES('229','VE','Venezuela');
INSERT INTO countries VALUES('230','VN','Vietnam');
INSERT INTO countries VALUES('231','VG','Virigan Islands (British)');
INSERT INTO countries VALUES('232','VI','Virgin Islands (U.S.)');
INSERT INTO countries VALUES('233','WF','Wallis and Futuna Islands');
INSERT INTO countries VALUES('234','EH','Western Sahara');
INSERT INTO countries VALUES('235','YE','Yemen');
INSERT INTO countries VALUES('236','YU','Yugoslavia');
INSERT INTO countries VALUES('237','ZR','Zaire');
INSERT INTO countries VALUES('238','ZM','Zambia');
INSERT INTO countries VALUES('239','ZW','Zimbabwe');



CREATE TABLE `deduction_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deduction_types VALUES('1','Social Security System','2024-07-23 12:02:09','2025-05-22 14:36:50','2025-05-22 14:36:50');
INSERT INTO deduction_types VALUES('3','Health Insurance Corporation','2024-07-23 12:41:34','2025-05-22 14:36:39','2025-05-22 14:36:39');
INSERT INTO deduction_types VALUES('4','Home Development Mutual Fund','2024-07-23 12:41:45','2025-05-22 14:36:24','2025-05-22 14:36:24');
INSERT INTO deduction_types VALUES('5','Withholding Tax On Wages','2024-07-23 12:41:57','2024-07-23 12:41:57','');
INSERT INTO deduction_types VALUES('6','Other Statutory Deduction','2024-07-23 12:42:11','2024-07-23 12:42:11','');
INSERT INTO deduction_types VALUES('7','Test','2024-07-23 13:09:14','2024-07-23 13:09:41','2024-07-23 13:09:41');
INSERT INTO deduction_types VALUES('8','EMP. PF','2025-05-22 14:37:04','2025-05-22 14:38:04','');



CREATE TABLE `departments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `department_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_head` bigint unsigned DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_foreign` (`company_id`),
  KEY `departments_department_head_foreign` (`department_head`),
  CONSTRAINT `departments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `departments_department_head_foreign` FOREIGN KEY (`department_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES('1','CSE','1','9','','2020-07-27 10:14:20','2023-01-22 19:17:21');
INSERT INTO departments VALUES('2','Analyst','1','','','2020-07-27 10:21:45','2020-07-27 14:36:12');
INSERT INTO departments VALUES('3','Branch Head','11','','','2020-07-27 14:46:38','2025-05-22 15:14:33');
INSERT INTO departments VALUES('4','R&D','','','','2020-07-27 14:48:38','2020-07-27 14:49:10');
INSERT INTO departments VALUES('5','HR','11','','','2020-07-27 14:49:39','2025-05-22 15:02:38');
INSERT INTO departments VALUES('6','Publishing','11','','','2025-05-15 23:54:01','2025-05-15 23:54:01');
INSERT INTO departments VALUES('7','IT','11','','','2025-05-15 23:54:35','2025-05-15 23:54:35');
INSERT INTO departments VALUES('8','Account’s','11','','','2025-05-15 23:55:04','2025-05-15 23:55:04');



CREATE TABLE `deposit_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deposit_categories VALUES('1','EMPR  PF','2024-07-23 21:02:56','2025-05-22 14:39:57');
INSERT INTO deposit_categories VALUES('4','Salary','2024-07-23 21:04:35','2024-07-23 21:04:35');
INSERT INTO deposit_categories VALUES('5','Interest Income','2024-07-23 21:04:44','2024-07-23 21:04:44');
INSERT INTO deposit_categories VALUES('6','Regular Income','2024-07-23 21:04:53','2024-07-23 21:04:53');
INSERT INTO deposit_categories VALUES('7','Part Time Work','2024-07-23 21:05:03','2024-07-23 21:05:03');
INSERT INTO deposit_categories VALUES('8','Other Income','2024-07-23 21:05:12','2024-07-23 21:05:12');



CREATE TABLE `designations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `designation_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_department_id_foreign` (`department_id`),
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `designations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO designations VALUES('1','Senior Programmer','1','1','','2020-07-27 14:51:30','2020-07-27 14:51:30');
INSERT INTO designations VALUES('2','Android Developer','1','1','','2020-07-27 14:58:30','2020-07-27 14:58:52');
INSERT INTO designations VALUES('3','Data Analyst','1','2','','2020-07-27 14:59:37','2020-07-27 14:59:37');
INSERT INTO designations VALUES('4','Marketing Analyst','1','2','','2020-07-27 15:00:02','2020-07-27 15:00:02');
INSERT INTO designations VALUES('5','Finance Manager','11','3','','2020-07-27 15:00:17','2025-05-22 15:15:36');
INSERT INTO designations VALUES('6','Trend Researcher','','4','','2020-07-27 15:00:52','2020-07-27 15:00:52');
INSERT INTO designations VALUES('7','HR manager','11','5','','2020-07-27 15:01:05','2025-05-22 15:02:13');
INSERT INTO designations VALUES('8','Web Developer','11','7','','2025-05-16 11:57:06','2025-05-16 11:57:06');



CREATE TABLE `document_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `document_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO document_types VALUES('1','Driving Licesnse','2020-07-27 01:57:04','2020-07-27 01:57:04');
INSERT INTO document_types VALUES('2','Passport','2020-07-27 01:57:16','2020-07-27 01:57:16');
INSERT INTO document_types VALUES('3','National Id','2020-07-27 01:57:40','2020-07-27 01:57:40');
INSERT INTO document_types VALUES('9','PAN Card','2025-05-16 13:59:23','2025-05-16 13:59:23');



CREATE TABLE `employee_bank_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `account_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_branch` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_bank_accounts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_bank_accounts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_bank_accounts VALUES('2','11','Nei-Dezhi','P-123','Prime Bank','P-987','Muradpur','2021-01-26 02:42:02','2021-01-26 02:48:32');
INSERT INTO employee_bank_accounts VALUES('5','9','Sabiha','M-123456','Mutual Trust Bank','MTB-123','Dhaka','2021-01-25 23:55:10','2021-01-25 23:55:10');



CREATE TABLE `employee_contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `relation_type_id` bigint unsigned NOT NULL DEFAULT '1',
  `is_primary` tinyint DEFAULT '0',
  `is_dependent` tinyint DEFAULT '0',
  `contact_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `work_phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `work_phone_ext` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `personal_phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `work_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `personal_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_contacts_employee_id_foreign` (`employee_id`),
  KEY `employee_contacts_relation_type_id_foreign` (`relation_type_id`),
  CONSTRAINT `employee_contacts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_contacts_relation_type_id_foreign` FOREIGN KEY (`relation_type_id`) REFERENCES `relation_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_contacts VALUES('2','9','2','','','Haley Miranda','4422443423','2434234234','2334234','2342423423','myliwulun@mailinator.com','suguroxuz@mailinator.com','43 Oak Court','Ab earum tempor in c','Et quia temporibus r','Perspiciatis eos e','36865','226','2024-07-22 22:41:49','2024-07-22 22:50:57');



CREATE TABLE `employee_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `document_type_id` bigint unsigned DEFAULT NULL,
  `document_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `document_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_documents_employee_id_foreign` (`employee_id`),
  KEY `employee_documents_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_documents_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_documents VALUES('6','9','1','Test','','Test.1674448248.jpeg','2023-01-26','1','2023-01-23 10:00:48','2023-01-23 11:07:26');



CREATE TABLE `employee_immigrations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `document_type_id` bigint unsigned DEFAULT NULL,
  `document_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `eligible_review_date` date DEFAULT NULL,
  `country_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_immigrations_employee_id_foreign` (`employee_id`),
  KEY `employee_immigrations_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_immigrations_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_immigrations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_immigrations VALUES('3','9','1','56757577657','immigration_56757577657.pdf','0000-00-00','2022-05-15','2022-05-21','1','2022-05-26 09:29:37','2022-05-26 09:54:47');
INSERT INTO employee_immigrations VALUES('4','9','2','7868688676','immigration_7868688676.pdf','2022-05-01','2022-05-10','2022-05-15','1','2022-05-26 09:44:50','2022-05-26 09:44:50');
INSERT INTO employee_immigrations VALUES('6','9','2','Test','immigration_Test.jpeg','2023-01-23','2023-01-30','2023-01-30','20','2023-01-23 11:27:37','2023-01-23 11:27:37');
INSERT INTO employee_immigrations VALUES('7','9','1','76686','immigration_76686.jpg','2024-07-17','2024-07-18','2024-07-10','19','2024-07-09 16:09:45','2024-07-09 16:09:45');



CREATE TABLE `employee_interview` (
  `interview_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`employee_id`),
  KEY `employee_interview_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_interview_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_interview VALUES('1','9');
INSERT INTO employee_interview VALUES('2','9');
INSERT INTO employee_interview VALUES('3','9');
INSERT INTO employee_interview VALUES('1','11');



CREATE TABLE `employee_leave_type_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `leave_type_detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_leave_type_details_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_leave_type_details_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_leave_type_details VALUES('3','11','a:4:{i:0;a:4:{s:13:\"leave_type_id\";i:1;s:10:\"leave_type\";s:7:\"Medical\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:10;}i:1;a:4:{s:13:\"leave_type_id\";i:2;s:10:\"leave_type\";s:6:\"Casual\";s:13:\"allocated_day\";s:1:\"5\";s:23:\"remaining_allocated_day\";i:5;}i:2;a:4:{s:13:\"leave_type_id\";i:3;s:10:\"leave_type\";s:6:\"Others\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:6;}i:3;a:4:{s:13:\"leave_type_id\";i:12;s:10:\"leave_type\";s:8:\"Maternal\";s:13:\"allocated_day\";s:1:\"3\";s:23:\"remaining_allocated_day\";i:3;}}','2023-04-03 11:10:35','2025-05-22 14:29:08');
INSERT INTO employee_leave_type_details VALUES('13','51','a:4:{i:0;a:4:{s:13:\"leave_type_id\";i:1;s:10:\"leave_type\";s:7:\"Medical\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:10;}i:1;a:4:{s:13:\"leave_type_id\";i:2;s:10:\"leave_type\";s:6:\"Casual\";s:13:\"allocated_day\";s:1:\"5\";s:23:\"remaining_allocated_day\";i:5;}i:2;a:4:{s:13:\"leave_type_id\";i:3;s:10:\"leave_type\";s:6:\"Others\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:10;}i:3;a:4:{s:13:\"leave_type_id\";i:12;s:10:\"leave_type\";s:8:\"Maternal\";s:13:\"allocated_day\";s:1:\"3\";s:23:\"remaining_allocated_day\";i:3;}}','2023-04-03 11:10:35','2025-05-22 14:29:08');
INSERT INTO employee_leave_type_details VALUES('16','9','a:4:{i:0;a:4:{s:13:\"leave_type_id\";i:1;s:10:\"leave_type\";s:7:\"Medical\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:0;}i:1;a:4:{s:13:\"leave_type_id\";i:2;s:10:\"leave_type\";s:6:\"Casual\";s:13:\"allocated_day\";s:1:\"5\";s:23:\"remaining_allocated_day\";i:5;}i:2;a:4:{s:13:\"leave_type_id\";i:3;s:10:\"leave_type\";s:6:\"Others\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:8;}i:3;a:4:{s:13:\"leave_type_id\";i:12;s:10:\"leave_type\";s:8:\"Maternal\";s:13:\"allocated_day\";s:1:\"3\";s:23:\"remaining_allocated_day\";i:3;}}','2023-04-12 14:47:43','2025-05-22 14:29:08');
INSERT INTO employee_leave_type_details VALUES('19','59','a:4:{i:0;a:4:{s:13:\"leave_type_id\";i:1;s:10:\"leave_type\";s:7:\"Medical\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:10;}i:1;a:4:{s:13:\"leave_type_id\";i:2;s:10:\"leave_type\";s:6:\"Casual\";s:13:\"allocated_day\";s:1:\"5\";s:23:\"remaining_allocated_day\";i:5;}i:2;a:4:{s:13:\"leave_type_id\";i:3;s:10:\"leave_type\";s:6:\"Others\";s:13:\"allocated_day\";s:2:\"10\";s:23:\"remaining_allocated_day\";i:10;}i:3;a:4:{s:13:\"leave_type_id\";i:12;s:10:\"leave_type\";s:8:\"Maternal\";s:13:\"allocated_day\";s:1:\"3\";s:23:\"remaining_allocated_day\";i:3;}}','2025-05-16 13:45:32','2025-05-22 14:29:08');



CREATE TABLE `employee_meeting` (
  `employee_id` bigint unsigned NOT NULL,
  `meeting_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`meeting_id`),
  KEY `employee_meeting_meeting_id_foreign` (`meeting_id`),
  CONSTRAINT `employee_meeting_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_meeting_meeting_id_foreign` FOREIGN KEY (`meeting_id`) REFERENCES `meetings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_meeting VALUES('9','1');
INSERT INTO employee_meeting VALUES('11','1');
INSERT INTO employee_meeting VALUES('9','2');
INSERT INTO employee_meeting VALUES('9','3');
INSERT INTO employee_meeting VALUES('9','4');
INSERT INTO employee_meeting VALUES('9','5');



CREATE TABLE `employee_project` (
  `employee_id` bigint unsigned NOT NULL,
  `project_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`project_id`),
  KEY `employee_project_project_id_foreign` (`project_id`),
  CONSTRAINT `employee_project_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_project_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_project VALUES('9','1');
INSERT INTO employee_project VALUES('11','1');
INSERT INTO employee_project VALUES('9','3');
INSERT INTO employee_project VALUES('9','4');



CREATE TABLE `employee_qualificaitons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `education_level_id` bigint unsigned DEFAULT NULL,
  `institution_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `language_skill_id` bigint unsigned DEFAULT NULL,
  `general_skill_id` bigint unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_qualificaitons_employee_id_foreign` (`employee_id`),
  KEY `employee_qualificaitons_education_level_id_foreign` (`education_level_id`),
  KEY `employee_qualificaitons_language_skill_id_foreign` (`language_skill_id`),
  KEY `employee_qualificaitons_general_skill_id_foreign` (`general_skill_id`),
  CONSTRAINT `employee_qualificaitons_education_level_id_foreign` FOREIGN KEY (`education_level_id`) REFERENCES `qualification_education_levels` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_qualificaitons_general_skill_id_foreign` FOREIGN KEY (`general_skill_id`) REFERENCES `qualification_skills` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_language_skill_id_foreign` FOREIGN KEY (`language_skill_id`) REFERENCES `qualification_languages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_support_ticket` (
  `employee_id` bigint unsigned NOT NULL,
  `support_ticket_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`support_ticket_id`),
  KEY `employee_support_ticket_support_ticket_id_foreign` (`support_ticket_id`),
  CONSTRAINT `employee_support_ticket_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_support_ticket_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_support_ticket VALUES('59','5');



CREATE TABLE `employee_task` (
  `employee_id` bigint unsigned NOT NULL,
  `task_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`task_id`),
  KEY `employee_task_task_id_foreign` (`task_id`),
  CONSTRAINT `employee_task_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_task_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_task VALUES('11','1');
INSERT INTO employee_task VALUES('9','7');
INSERT INTO employee_task VALUES('9','8');



CREATE TABLE `employee_training_list` (
  `employee_id` bigint unsigned NOT NULL,
  `training_list_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`training_list_id`),
  KEY `employee_training_list_training_list_id_foreign` (`training_list_id`),
  CONSTRAINT `employee_training_list_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_training_list_training_list_id_foreign` FOREIGN KEY (`training_list_id`) REFERENCES `training_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_training_list VALUES('9','1');
INSERT INTO employee_training_list VALUES('9','2');



CREATE TABLE `employee_work_experience` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `post` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_work_experience_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_work_experience_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_work_experience VALUES('2','9','dsfdsf','2022-12-20','2022-12-21','sdfdsfs','fdsfdsfsdfdfsd','2022-12-19 12:59:12','2022-12-19 12:59:12');



CREATE TABLE `employees` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `staff_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office_shift_id` bigint unsigned DEFAULT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `designation_id` bigint unsigned DEFAULT NULL,
  `location_id` bigint unsigned DEFAULT NULL,
  `role_users_id` bigint unsigned DEFAULT NULL,
  `status_id` bigint unsigned DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `exit_date` date DEFAULT NULL,
  `marital_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `city` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cv` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fb_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedIn_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `basic_salary` double DEFAULT '0',
  `payslip_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attendance_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pension_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pension_amount` double(8,2) DEFAULT '0.00',
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_office_shift_id_foreign` (`office_shift_id`),
  KEY `employees_company_id_foreign` (`company_id`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`),
  KEY `employees_location_id_foreign` (`location_id`),
  KEY `employees_role_users_id_foreign` (`role_users_id`),
  KEY `employees_status_id_foreign` (`status_id`),
  CONSTRAINT `employees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_id_foreign` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employees_office_shift_id_foreign` FOREIGN KEY (`office_shift_id`) REFERENCES `office_shifts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employees_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employees_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES('9','Sahiba','Khatun','1','irfanchowdhury434@gmail.com','387292822','1990-09-25','Female','','1','1','2','','2','1','2020-01-02','','single','22,new street','Sharjha','UAE','222','6753','','Sabiha95','','','','123456789','100','Monthly','general','percentage','50.00','','2020-07-27 01:21:54','2025-05-17 14:22:13');
INSERT INTO employees VALUES('11','Neo','Dezhi','3','dezhi@gmail.com','67278232','1991-03-29','Male','','1','3','5','','6','1','2020-07-01','','','','','','','','','Deshi321','','','','987456','100','Monthly','general','','0.00','','2020-07-27 01:33:25','2025-05-17 14:20:28');
INSERT INTO employees VALUES('51','Lacey','Wood','13','myjof@mailinator.com','1211334234','2022-03-28','Female','','1','1','1','','1','1','2022-03-24','','','','','','','','','','','','','','0','','general','','0.00','1','2022-03-28 10:16:07','2022-05-24 12:38:37');
INSERT INTO employees VALUES('59','Nitesh','Yadav','1238200','developer@cbspd.com','08467930685','1994-07-06','Male','3','11','7','8','','2','1','2023-08-23','','single','','','','99','','','','','','','','58544','Monthly','general','fixed','1800.00','1','2025-05-16 13:45:32','2025-05-22 15:22:24');



CREATE TABLE `events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `department_id` bigint unsigned NOT NULL,
  `event_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_date` date NOT NULL,
  `event_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_notify` tinyint DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_company_id_foreign` (`company_id`),
  KEY `events_department_id_foreign` (`department_id`),
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `events_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO events VALUES('1','1','2','Birthday Party','Today is the birthday of our honourable HR','2021-04-03','04:20PM','approved','1','2020-07-28 19:48:56','2020-07-28 19:54:17');
INSERT INTO events VALUES('2','1','3','test','dacd','2021-02-28','07:40PM','approved','','2020-10-27 06:59:18','2020-10-27 06:59:18');
INSERT INTO events VALUES('3','1','1','HNY','Test','2023-01-01','09:00PM','approved','','2023-01-01 12:35:27','2023-01-01 12:36:12');
INSERT INTO events VALUES('4','1','1','Event Test','Test','2023-02-21','01:00AM','approved','','2023-02-09 10:36:43','2023-02-09 10:36:43');



CREATE TABLE `expense_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_types_company_id_foreign` (`company_id`),
  CONSTRAINT `expense_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expense_types VALUES('1','1','utility','2020-07-27 01:52:56','2020-07-27 01:52:56');
INSERT INTO expense_types VALUES('2','1','supplies','2020-07-27 01:53:10','2020-07-27 01:53:10');



CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `file_manager_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `allowed_extensions` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_file_size` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO file_manager_settings VALUES('1','jpg,png,doc,docx,pdf,csv,xls,jpeg','20','2020-07-29 11:29:20','2020-07-29 11:29:20');



CREATE TABLE `file_managers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `department_id` bigint unsigned DEFAULT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  `file_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_extension` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_managers_department_id_foreign` (`department_id`),
  KEY `file_managers_added_by_foreign` (`added_by`),
  CONSTRAINT `file_managers_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `file_managers_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO file_managers VALUES('1','1','1','New','185.04 KB','pdf','','2020-07-29 11:31:33','2020-07-29 11:31:33');



CREATE TABLE `finance_bank_cashes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_balance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_balance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_branch` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO finance_bank_cashes VALUES('3','PNB','3834156','3929929','9382892','9292','CP','2025-05-16 13:55:26','2025-05-22 15:29:31');



CREATE TABLE `finance_deposits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `amount` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deposit_category_id` bigint unsigned NOT NULL DEFAULT '1',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method_id` bigint unsigned DEFAULT NULL,
  `payer_id` bigint unsigned DEFAULT NULL,
  `deposit_reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deposit_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deposit_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_deposits_company_id_foreign` (`company_id`),
  KEY `finance_deposits_account_id_foreign` (`account_id`),
  KEY `finance_deposits_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_deposits_payer_id_foreign` (`payer_id`),
  KEY `finance_deposits_deposit_category_id_foreign` (`deposit_category_id`),
  CONSTRAINT `finance_deposits_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_deposits_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_deposits_deposit_category_id_foreign` FOREIGN KEY (`deposit_category_id`) REFERENCES `deposit_categories` (`id`),
  CONSTRAINT `finance_deposits_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_deposits_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `amount` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method_id` bigint unsigned DEFAULT NULL,
  `payee_id` bigint unsigned DEFAULT NULL,
  `expense_reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expense_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_expenses_company_id_foreign` (`company_id`),
  KEY `finance_expenses_account_id_foreign` (`account_id`),
  KEY `finance_expenses_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_expenses_payee_id_foreign` (`payee_id`),
  KEY `finance_expenses_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_expenses_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_expenses_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_expenses_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO finance_expenses VALUES('120','','3','95773.00','','','','','Payroll','','2025-05-22','2025-05-22 15:29:31','2025-05-22 15:29:31');



CREATE TABLE `finance_payees` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payee_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO finance_payees VALUES('1','Mr. A','563345','2020-07-28 22:52:13','2020-07-28 22:52:13');
INSERT INTO finance_payees VALUES('2','Mr. B','5656353','2020-07-28 22:52:31','2020-07-28 22:52:31');



CREATE TABLE `finance_payers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payer_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO finance_payers VALUES('1','Mr. X','34242','2020-07-28 22:53:01','2020-07-28 22:53:01');
INSERT INTO finance_payers VALUES('2','Mr. Z','54563','2020-07-28 22:53:19','2020-07-28 22:53:19');



CREATE TABLE `finance_transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `amount` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method_id` bigint unsigned DEFAULT NULL,
  `payee_id` bigint unsigned DEFAULT NULL,
  `payer_id` bigint unsigned DEFAULT NULL,
  `expense_reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `deposit_reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deposit_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transactions_company_id_foreign` (`company_id`),
  KEY `finance_transactions_account_id_foreign` (`account_id`),
  KEY `finance_transactions_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_transactions_payee_id_foreign` (`payee_id`),
  KEY `finance_transactions_payer_id_foreign` (`payer_id`),
  KEY `finance_transactions_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_transactions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transactions_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transactions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transactions_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transactions_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transactions_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO finance_transactions VALUES('120','','3','95773.00','','','','','','','Payroll','','2025-05-22','','','','2025-05-22 15:29:31','2025-05-22 15:29:31');



CREATE TABLE `finance_transfers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `from_account_id` bigint unsigned DEFAULT NULL,
  `to_account_id` bigint unsigned DEFAULT NULL,
  `amount` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method_id` bigint unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transfers_company_id_foreign` (`company_id`),
  KEY `finance_transfers_from_account_id_foreign` (`from_account_id`),
  KEY `finance_transfers_to_account_id_foreign` (`to_account_id`),
  KEY `finance_transfers_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `finance_transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transfers_from_account_id_foreign` FOREIGN KEY (`from_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transfers_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `finance_transfers_to_account_id_foreign` FOREIGN KEY (`to_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `site_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_zone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_payment_bank` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES('1','CBSPD','logo.png','Asia/Kolkata','₹','prefix','3','d-m-Y','default.css','Copyright CBSPD','https://www.cbspd.com','2020-07-26 00:30:00','2025-05-17 13:10:24');



CREATE TABLE `goal_trackings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `goal_type_id` bigint unsigned NOT NULL,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_achievement` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `start_date` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `progress` int NOT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `goal_trackings_company_id_foreign` (`company_id`),
  KEY `goal_trackings_goal_type_id_foreign` (`goal_type_id`),
  CONSTRAINT `goal_trackings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `goal_trackings_goal_type_id_foreign` FOREIGN KEY (`goal_type_id`) REFERENCES `goal_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO goal_trackings VALUES('1','1','1','Testing-1 Subject','Testing-1 Achievement','Testing-1 Description','01/17/2021','01/18/2021','38','In Progress','2021-01-17 10:44:15','2021-01-17 10:44:39');
INSERT INTO goal_trackings VALUES('4','1','3','Testing-3 Subject','Testing-3 Achievement','Testing 3 Description','01/21/2021','01/22/2021','90','Completed','2021-01-17 10:46:28','2021-01-17 10:48:21');



CREATE TABLE `goal_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `goal_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO goal_types VALUES('1','Event Goal','2021-01-17 09:44:44','2021-01-17 09:44:44');
INSERT INTO goal_types VALUES('2','Success Goal','2021-01-17 09:44:58','2021-01-17 09:44:58');
INSERT INTO goal_types VALUES('3','Complete','2021-01-17 10:10:18','2021-01-17 10:10:18');



CREATE TABLE `holidays` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_publish` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id_foreign` (`company_id`),
  KEY `holidays_department_id_foreign` (`department_id`),
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `holidays_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO holidays VALUES('1','Eid Ul Adha','ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum q','1','','2021-03-30','2021-04-01','1','2020-07-27 23:37:35','2020-07-27 23:37:35');
INSERT INTO holidays VALUES('2','Victory Day','This is our national victory day','1','','2022-12-16','2022-12-16','1','2022-11-17 10:16:58','2022-11-17 10:16:58');
INSERT INTO holidays VALUES('3','Test','Test','1','','2022-11-17','2022-11-18','1','2022-11-17 10:25:16','2022-11-17 10:25:59');
INSERT INTO holidays VALUES('4','Christmas Day','Public Holiday','1','','2022-12-25','2022-12-25','1','2022-12-29 12:41:09','2022-12-29 12:41:09');
INSERT INTO holidays VALUES('5','Ekushe February','','1','','2023-02-21','2023-02-22','1','2023-02-09 10:03:42','2023-02-09 10:03:42');



CREATE TABLE `indicators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `designation_id` bigint unsigned NOT NULL,
  `department_id` bigint unsigned NOT NULL,
  `customer_experience` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `marketing` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `administrator` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `professionalism` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `integrity` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attendance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `indicators_company_id_foreign` (`company_id`),
  KEY `indicators_department_id_foreign` (`department_id`),
  KEY `indicators_designation_id_foreign` (`designation_id`),
  CONSTRAINT `indicators_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `indicators_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `indicators_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO indicators VALUES('1','1','2','1','None','Beginner','Intermidiate','Expert/Leader','Advanced','Advanced','admin','2021-01-17 11:46:32','2021-01-17 11:46:32');
INSERT INTO indicators VALUES('2','1','3','2','None','Beginner','Intermidiate','Advanced','Advanced','Expert/Leader','admin','2021-01-17 11:47:10','2021-01-17 11:47:10');
INSERT INTO indicators VALUES('4','11','8','7','Intermidiate','Beginner','None','Intermidiate','Intermidiate','Advanced','admin','2025-05-17 15:14:32','2025-05-17 15:14:32');



CREATE TABLE `invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned DEFAULT NULL,
  `project_id` bigint unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_tax_type` int NOT NULL DEFAULT '0',
  `item_tax_rate` decimal(5,2) NOT NULL,
  `item_qty` int NOT NULL DEFAULT '0',
  `item_unit_price` decimal(10,2) NOT NULL,
  `item_sub_total` double NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_items_project_id_foreign` (`project_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoice_items_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `project_id` bigint unsigned DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `invoice_due_date` date NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `invoice_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ip_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO ip_settings VALUES('1','FNF','103.120.140.1','2021-03-28 20:04:42','2021-03-28 22:27:27');
INSERT INTO ip_settings VALUES('14','Lion-Coders','127.54.03.1','2021-03-28 22:28:02','2021-03-28 22:28:02');
INSERT INTO ip_settings VALUES('15','Local','127.0.0.2','2021-03-28 22:56:13','2021-03-29 11:09:40');
INSERT INTO ip_settings VALUES('16','XYZ','103.161.152.57','2021-07-05 09:06:35','2021-08-01 18:34:10');



CREATE TABLE `job_candidates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cover_letter` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fb_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cv` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_candidates_job_id_foreign` (`job_id`),
  CONSTRAINT `job_candidates_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO job_candidates VALUES('1','1','John Stones','john_stones@gmail.com','','','Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin rhoncus, quam et ultricies vulputate, mauris arcu viverra ipsum, nec interdum dui ipsum id elit. Vivamus vehicula posuere commodo. Curabitur consectetur lacus nisi. Mauris vitae pulvinar lacus. Vestibulum malesuada felis magna, in convallis tortor lobortis ac.','jonh@fb.com','john_stones','JohnStones_1603445937.pdf','applied','','2020-10-23 12:08:57','2020-10-23 12:08:57');
INSERT INTO job_candidates VALUES('2','1','Micah Dudley','mevytoparo@mailinator.com','8688688','jljljl','Deserunt enim tempor','Totam dolorem necess','Voluptatem magna et','MicahDudley_1699290572.jpeg','applied','','2023-11-06 22:09:32','2023-11-06 22:09:32');
INSERT INTO job_candidates VALUES('3','1','Fahim Chowdhury','irfanchowdhury434@gmail.com','2212221212','Dewanhat, Chittagong.','Dear Hiring Manager,

I would like to apply for the position of Software Developer (PHP-Laravel) as advertised on Facebook. I have extensive experience in web development specializing in PHP-Laravel, JavaScript, jQuery, Ajax, API, little experience with React and others that perfectly fit the advertised job requirements. 

I received my B.Sc. in Computer Science &amp; Engineering from International Islamic University Chittagong and have more than 2.5 years in software development as Junior Software Engineer at Lion Coders , Chittagong. 

Please find my resume attached. Feel free to contact me if you have any further questions you would like to discuss. Thank you for taking the time to consider my application. I look forward to hearing from you.


Thanks &amp; Regards,

Md Irfan Chowdhury
.','','','FahimChowdhury_1700042575.jpg','Called For Interview','','2023-11-15 15:02:55','2023-11-15 22:54:36');
INSERT INTO job_candidates VALUES('4','1','Zena Blanchard','irfanchowdhury434@gmail.com','+1 (588) 429-5669','Quaerat est perferen','Perspiciatis magna','Velit aut consectet','Alias et saepe numqu','ZenaBlanchard_1700073165.png','applied','','2023-11-15 23:32:45','2023-11-15 23:32:45');
INSERT INTO job_candidates VALUES('5','1','Md Irfan','irfanchowdhury@gmail.com','23234234223','Agrabad, Chittagong','Hello, I want to apply for this role.','','','MdIrfan_1722139144.pdf','applied','','2024-07-28 08:59:04','2024-07-28 08:59:04');



CREATE TABLE `job_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `job_category` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO job_categories VALUES('2','PHP','xdBCMHJABdhRlMqXkA0G');
INSERT INTO job_categories VALUES('3','Seo','YoHOIZmN5jdNLG6gMp3x');
INSERT INTO job_categories VALUES('5','Analyst','gDCJcrUn9M7tt5xVK3wh');



CREATE TABLE `job_experiences` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO job_experiences VALUES('1','Fresher','2024-07-28 14:09:14','2024-07-28 14:09:14');
INSERT INTO job_experiences VALUES('2','1-3 Years','2024-07-28 14:09:23','2025-05-22 14:40:45');
INSERT INTO job_experiences VALUES('4','4-7 Years','2024-07-28 14:14:55','2025-05-22 14:42:16');
INSERT INTO job_experiences VALUES('11','8+ Years','2024-07-28 14:39:25','2025-05-22 14:42:40');
INSERT INTO job_experiences VALUES('12','12+ Years','2024-07-28 14:39:30','2025-05-22 14:42:58');



CREATE TABLE `job_interviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint unsigned NOT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  `interview_place` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `interview_date` date NOT NULL,
  `interview_time` time NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_interviews_job_id_foreign` (`job_id`),
  KEY `job_interviews_added_by_foreign` (`added_by`),
  CONSTRAINT `job_interviews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `job_interviews_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO job_interviews VALUES('1','1','1','Dewanhat, Chittagong','2023-11-17','03:00:00','&lt;p&gt;&lt;span style=&quot;background-color: #ffffff; color: #718096; font-family: -apple-system, BlinkMacSystemFont, &#039;Segoe UI&#039;, Roboto, Helvetica, Arial, sans-serif, &#039;Apple Color Emoji&#039;, &#039;Segoe UI Emoji&#039;, &#039;Segoe UI Symbol&#039;; font-size: 16px;&quot;&gt;Interview for caregiver position kghomehealth&lt;/span&gt;&lt;/p&gt;','2023-11-15 15:10:26','2023-11-15 15:10:26');
INSERT INTO job_interviews VALUES('2','1','1','dhaka bangladesh','2023-11-16','03:00:00','&lt;p&gt;&lt;span style=&quot;background-color: #ffffff; color: #718096; font-family: -apple-system, BlinkMacSystemFont, &#039;Segoe UI&#039;, Roboto, Helvetica, Arial, sans-serif, &#039;Apple Color Emoji&#039;, &#039;Segoe UI Emoji&#039;, &#039;Segoe UI Symbol&#039;; font-size: 16px;&quot;&gt;Interview for caregiver position kghomehealth&lt;/span&gt;&lt;/p&gt;','2023-11-15 22:44:24','2023-11-15 22:44:24');
INSERT INTO job_interviews VALUES('3','1','1','CTG, BD','2023-11-18','03:00:00','&lt;p&gt;Interview for caregiver position kghomehealth&lt;/p&gt;','2023-11-15 22:54:36','2023-11-15 22:54:36');



CREATE TABLE `job_posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `job_category_id` bigint unsigned NOT NULL,
  `job_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `no_of_vacancy` int NOT NULL,
  `job_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_experience_id` bigint unsigned NOT NULL DEFAULT '1',
  `short_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `long_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `closing_date` date NOT NULL,
  `status` tinyint NOT NULL,
  `is_featured` tinyint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_posts_job_category_id_foreign` (`job_category_id`),
  KEY `job_posts_company_id_foreign` (`company_id`),
  KEY `job_posts_job_experience_id_foreign` (`job_experience_id`),
  CONSTRAINT `job_posts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `job_posts_job_category_id_foreign` FOREIGN KEY (`job_category_id`) REFERENCES `job_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `job_posts_job_experience_id_foreign` FOREIGN KEY (`job_experience_id`) REFERENCES `job_experiences` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO job_posts VALUES('1','1','2','Laravel Developer','full_time','2','qPnZoMWx83Qb0YnTVl5F','No Preference','1','Lion-Coders is looking for Intermediate level Software Developers (3) for its Laravel based software developments. The primary role of these developers will be to develop/debug new desktop/xamarin/web applications for its overseas clients.','&lt;p&gt;&amp;bull; Should have experience in working on framework such as Laravel,&lt;br /&gt;Symphony etc&lt;br /&gt;&amp;bull; Excellent working knowledge of Web application development&lt;br /&gt;&amp;bull; Advance coding Skills in PHP, HTML, CSS, JavaScript, and scripting&lt;br /&gt;languages desirable&lt;br /&gt;&amp;bull; Excellent working knowledge of MySQL database&lt;br /&gt;&amp;bull; Good understanding of database performance tuning and sql queries&lt;br /&gt;&amp;bull; Experience working with a PHP framework such as CodeIgniter/Laravel&lt;br /&gt;&amp;bull; Experience in both Front End / Back End Developer.&lt;br /&gt;&amp;bull; Good Knowledge and understanding of CRM, CMS, SHOPPING-CART,&lt;br /&gt;PAYMENT GATEWAY &amp;amp; other API INTEGRATION&lt;/p&gt;','2021-03-06','1','1','2021-02-22 05:30:00','2021-03-24 07:16:04');
INSERT INTO job_posts VALUES('2','1','5','Business Analyst','part_time','3','OhBIUt70qzUGfzfWifEI','Male','1','Business analysts work with organizations to help them improve their processes and systems. They conduct research and analysis in order to come up with solutions to business problems and help to introduce these systems to businesses and their clients.','&lt;p&gt;Important skills needed :&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;Oral and written communication skills&lt;/li&gt;
&lt;li&gt;nterpersonal and consultative skills&lt;/li&gt;
&lt;li&gt;Facilitation skills&lt;/li&gt;
&lt;li&gt;Analytical thinking and problem solving&lt;/li&gt;
&lt;li&gt;Being detail-oriented and capable of delivering a high level of accuracy&lt;/li&gt;
&lt;li&gt;Organizational skills&lt;/li&gt;
&lt;/ul&gt;','2021-03-03','1','1','2021-02-23 05:30:00','2021-03-24 07:16:46');
INSERT INTO job_posts VALUES('4','1','2','dfdfds','full_time','1','XTWZGx3nl9LVvaIMHuN8','Male','1','dczcz','&lt;p&gt;xczxczczx&lt;/p&gt;','2023-08-03','1','1','2023-08-02 01:52:01','2023-08-02 01:52:01');
INSERT INTO job_posts VALUES('6','1','2','Ipsum eveniet unde','internship','8','tpH2FtqLT75Nac0HmWdD','Female','4','Dolor sequi velit v','&lt;p&gt;Vel in commodi excep.&lt;/p&gt;','2024-07-28','1','1','2024-07-28 15:09:17','2024-07-28 15:11:47');



CREATE TABLE `languages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO languages VALUES('1','','English','2023-05-06 11:09:11','2023-05-06 11:09:11');



CREATE TABLE `leave_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `allocated_day` int DEFAULT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO leave_types VALUES('1','Medical','10','','2020-07-27 01:48:04','2025-05-16 14:00:06');
INSERT INTO leave_types VALUES('2','Casual','5','','2020-07-27 01:48:39','2023-03-29 14:44:37');
INSERT INTO leave_types VALUES('3','Others','10','','2020-07-27 01:48:48','2023-04-01 13:44:39');
INSERT INTO leave_types VALUES('12','Maternal','3','','2023-11-06 08:08:00','2025-05-22 14:29:08');



CREATE TABLE `leaves` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `leave_type_id` bigint unsigned DEFAULT NULL,
  `company_id` bigint unsigned NOT NULL,
  `department_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `total_days` int NOT NULL,
  `leave_reason` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `remarks` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_notify` tinyint DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leaves_company_id_foreign` (`company_id`),
  KEY `leaves_employee_id_foreign` (`employee_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_department_id_foreign` (`department_id`),
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO leaves VALUES('1','3','1','1','9','2021-02-14','2021-02-15','2','tem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu','tem vel eum iure reprehenderit qui in ea','approved','1','2020-07-28 00:10:11','2020-07-28 00:10:11');
INSERT INTO leaves VALUES('26','1','1','1','9','2023-01-23','2023-01-24','2','','','approved','1','2023-01-22 18:35:33','2023-01-22 18:35:33');
INSERT INTO leaves VALUES('27','3','1','3','11','2023-01-23','2023-01-24','2','','','approved','1','2023-01-22 18:38:02','2023-01-22 18:38:02');
INSERT INTO leaves VALUES('30','3','1','3','11','2023-01-27','2023-01-28','2','','','approved','1','2023-01-22 19:01:00','2023-01-22 19:01:00');
INSERT INTO leaves VALUES('39','1','1','1','9','2023-04-10','2023-04-13','4','','','approved','','2023-04-02 11:35:29','2023-04-11 15:42:37');
INSERT INTO leaves VALUES('40','1','1','1','9','2023-04-03','2023-04-03','1','','','approved','','2023-04-02 12:44:06','2023-04-02 12:44:06');
INSERT INTO leaves VALUES('41','1','1','1','9','2023-04-06','2023-04-06','1','','','approved','','2023-04-02 12:45:09','2023-04-02 12:45:09');
INSERT INTO leaves VALUES('42','1','1','1','9','2023-04-07','2023-04-07','1','','','approved','','2023-04-02 12:46:10','2023-04-02 12:46:10');
INSERT INTO leaves VALUES('43','1','1','1','9','2023-04-05','2023-04-05','1','','','approved','','2023-04-02 13:51:16','2023-04-02 13:52:44');
INSERT INTO leaves VALUES('44','1','1','1','9','2023-04-03','2023-04-03','1','','','approved','','2023-04-02 14:34:09','2023-04-02 14:34:09');
INSERT INTO leaves VALUES('45','1','1','1','9','2023-04-05','2023-04-06','2','','','rejected','','2023-04-02 14:37:25','2023-04-03 14:55:04');
INSERT INTO leaves VALUES('46','1','1','1','9','2023-04-08','2023-04-14','7','','','approved','','2023-04-11 16:26:35','2023-04-12 14:17:01');
INSERT INTO leaves VALUES('47','1','1','1','9','2023-04-10','2023-04-12','3','','','pending','','2023-04-11 16:31:36','2023-04-12 14:49:57');
INSERT INTO leaves VALUES('48','1','1','1','9','2023-04-17','2023-04-18','2','','','approved','','2023-04-12 15:03:19','2023-04-12 15:03:48');
INSERT INTO leaves VALUES('49','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:42:55','2023-12-10 10:42:55');
INSERT INTO leaves VALUES('50','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO leaves VALUES('51','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO leaves VALUES('52','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO leaves VALUES('53','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO leaves VALUES('54','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO leaves VALUES('55','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO leaves VALUES('56','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO leaves VALUES('57','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:01','2023-12-10 10:43:01');
INSERT INTO leaves VALUES('58','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO leaves VALUES('59','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO leaves VALUES('60','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO leaves VALUES('61','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO leaves VALUES('62','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO leaves VALUES('63','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO leaves VALUES('64','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO leaves VALUES('65','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO leaves VALUES('66','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO leaves VALUES('67','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO leaves VALUES('68','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO leaves VALUES('69','1','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO leaves VALUES('70','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:09:20','2023-12-10 11:09:20');
INSERT INTO leaves VALUES('71','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:13:15','2023-12-10 11:13:15');
INSERT INTO leaves VALUES('72','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:14:04','2023-12-10 11:14:04');
INSERT INTO leaves VALUES('73','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:14:35','2023-12-10 11:14:35');
INSERT INTO leaves VALUES('74','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:14:57','2023-12-10 11:14:57');
INSERT INTO leaves VALUES('75','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:15:48','2023-12-10 11:15:48');
INSERT INTO leaves VALUES('76','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:17:31','2023-12-10 11:17:31');
INSERT INTO leaves VALUES('77','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:18:20','2023-12-10 11:18:20');
INSERT INTO leaves VALUES('78','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:19:41','2023-12-10 11:19:41');
INSERT INTO leaves VALUES('79','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:43:20','2023-12-10 11:43:20');
INSERT INTO leaves VALUES('80','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:43:46','2023-12-10 11:43:46');
INSERT INTO leaves VALUES('81','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:46:45','2023-12-10 11:46:45');
INSERT INTO leaves VALUES('82','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:46:48','2023-12-10 11:46:48');
INSERT INTO leaves VALUES('83','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:47:21','2023-12-10 11:47:21');
INSERT INTO leaves VALUES('84','2','1','1','9','2023-12-10','2023-12-11','2','test','','pending','','2023-12-10 11:49:32','2023-12-10 11:49:32');
INSERT INTO leaves VALUES('85','2','1','1','9','2023-12-10','2023-12-13','4','gggg','','pending','','2023-12-10 11:51:16','2023-12-10 11:51:16');
INSERT INTO leaves VALUES('86','2','1','1','9','2023-12-10','2023-12-13','4','gggg','','pending','','2023-12-10 11:51:35','2023-12-10 11:51:35');
INSERT INTO leaves VALUES('87','2','1','1','9','2023-12-10','2023-12-13','4','gggg','','pending','','2023-12-10 11:57:17','2023-12-10 11:57:17');
INSERT INTO leaves VALUES('88','2','1','1','9','2023-12-10','2023-12-13','4','gggg','','pending','','2023-12-10 11:58:53','2023-12-10 11:58:53');



CREATE TABLE `loan_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO loan_types VALUES('1','Personal Loan','2024-07-23 09:11:22','2025-05-22 14:36:00','');
INSERT INTO loan_types VALUES('3','Home Development Mutual Fund Loan','2024-07-23 09:13:09','2024-07-23 09:13:09','');
INSERT INTO loan_types VALUES('4','Other Loan','2024-07-23 09:15:02','2024-07-23 09:15:02','');



CREATE TABLE `locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_head` bigint unsigned DEFAULT NULL,
  `address1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` int unsigned DEFAULT NULL,
  `zip` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `locations_location_head_foreign` (`location_head`),
  KEY `locations_country_foreign` (`country`),
  CONSTRAINT `locations_country_foreign` FOREIGN KEY (`country`) REFERENCES `countries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `locations_location_head_foreign` FOREIGN KEY (`location_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO locations VALUES('4','Head office','','204','','New Delhi','Delhi','99','110092','2025-05-15 23:31:02','2025-05-15 23:31:38');
INSERT INTO locations VALUES('5','Mumbai','','Mumbai','','','','99','0','2025-05-15 23:52:27','2025-05-15 23:52:27');
INSERT INTO locations VALUES('6','Kolkata','','Kolkata','','','','99','0','2025-05-15 23:52:49','2025-05-15 23:52:49');
INSERT INTO locations VALUES('7','Lucknow','','Lucknow','','','','99','0','2025-05-15 23:53:10','2025-05-15 23:53:10');



CREATE TABLE `meetings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `meeting_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `meeting_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `meeting_date` date NOT NULL,
  `meeting_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_notify` tinyint DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meetings_company_id_foreign` (`company_id`),
  CONSTRAINT `meetings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO meetings VALUES('1','1','Project Vision','m et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod','2021-04-01','03:20PM','pending','1','2020-07-28 20:01:11','2020-07-28 20:01:11');
INSERT INTO meetings VALUES('2','1','Test Meeting','Test','2023-01-06','02:00PM','ongoing','','2023-01-02 14:42:22','2023-01-02 14:53:07');
INSERT INTO meetings VALUES('3','1','Test Meeting','Fsafsaf','2023-01-20','02:00PM','pending','','2023-01-02 14:43:01','2023-01-02 14:54:16');
INSERT INTO meetings VALUES('4','1','Meeting Ttitle','Test','2023-02-21','12:00AM','completed','','2023-02-09 10:37:23','2023-02-09 10:37:23');
INSERT INTO meetings VALUES('5','1','Meeting Ttitle','','2023-02-22','07:00AM','ongoing','','2023-02-09 10:40:16','2023-02-09 10:40:16');



CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('106','2023_05_06_053210_create_countries_table','1');
INSERT INTO migrations VALUES('107','2023_05_06_053211_create_locations_table','1');
INSERT INTO migrations VALUES('108','2023_05_06_053212_create_companies_table','1');
INSERT INTO migrations VALUES('109','2023_05_06_053213_create_departments_table','1');
INSERT INTO migrations VALUES('110','2023_05_06_053214_create_designations_table','1');
INSERT INTO migrations VALUES('111','2023_05_06_053215_create_roles_table','1');
INSERT INTO migrations VALUES('112','2023_05_06_053217_create_users_table','1');
INSERT INTO migrations VALUES('113','2023_05_06_053218_create_office_shifts_table','1');
INSERT INTO migrations VALUES('114','2023_05_06_053219_create_statuses_table','1');
INSERT INTO migrations VALUES('115','2023_05_06_053220_create_employees_table','1');
INSERT INTO migrations VALUES('116','2023_05_06_053221_create_announcements_table','1');
INSERT INTO migrations VALUES('117','2023_05_06_053222_create_appraisals_table','1');
INSERT INTO migrations VALUES('118','2023_05_06_053223_create_asset_categories_table','1');
INSERT INTO migrations VALUES('119','2023_05_06_053224_create_assets_table','1');
INSERT INTO migrations VALUES('120','2023_05_06_053225_create_attendances_table','1');
INSERT INTO migrations VALUES('121','2023_05_06_053226_create_award_types_table','1');
INSERT INTO migrations VALUES('122','2023_05_06_053227_create_awards_table','1');
INSERT INTO migrations VALUES('123','2023_05_06_053228_create_c_m_s_table','1');
INSERT INTO migrations VALUES('124','2023_05_06_053229_create_calendarables_table','1');
INSERT INTO migrations VALUES('125','2023_05_06_053231_create_clients_table','1');
INSERT INTO migrations VALUES('126','2023_05_06_053232_create_complaints_table','1');
INSERT INTO migrations VALUES('127','2023_05_06_053233_create_document_types_table','1');
INSERT INTO migrations VALUES('128','2023_05_06_053234_create_employee_bank_accounts_table','1');
INSERT INTO migrations VALUES('129','2023_05_06_053235_create_employee_contacts_table','1');
INSERT INTO migrations VALUES('130','2023_05_06_053236_create_employee_documents_table','1');
INSERT INTO migrations VALUES('131','2023_05_06_053237_create_employee_immigrations_table','1');
INSERT INTO migrations VALUES('132','2023_05_06_053238_create_employee_leave_type_details_table','1');
INSERT INTO migrations VALUES('133','2023_05_06_053239_create_job_categories_table','1');
INSERT INTO migrations VALUES('134','2023_05_06_053240_create_job_posts_table','1');
INSERT INTO migrations VALUES('135','2023_05_06_053241_create_job_interviews_table','1');
INSERT INTO migrations VALUES('136','2023_05_06_053242_create_employee_interview_table','1');
INSERT INTO migrations VALUES('137','2023_05_06_053243_create_meetings_table','1');
INSERT INTO migrations VALUES('138','2023_05_06_053244_create_employee_meeting_table','1');
INSERT INTO migrations VALUES('139','2023_05_06_053245_create_projects_table','1');
INSERT INTO migrations VALUES('140','2023_05_06_053246_create_employee_project_table','1');
INSERT INTO migrations VALUES('141','2023_05_06_053247_create_qualification_languages_table','1');
INSERT INTO migrations VALUES('142','2023_05_06_053248_create_qualification_skills_table','1');
INSERT INTO migrations VALUES('143','2023_05_06_053249_create_qualification_education_levels_table','1');
INSERT INTO migrations VALUES('144','2023_05_06_053250_create_employee_qualificaitons_table','1');
INSERT INTO migrations VALUES('145','2023_05_06_053251_create_support_tickets_table','1');
INSERT INTO migrations VALUES('146','2023_05_06_053252_create_employee_support_ticket_table','1');
INSERT INTO migrations VALUES('147','2023_05_06_053253_create_tasks_table','1');
INSERT INTO migrations VALUES('148','2023_05_06_053254_create_employee_task_table','1');
INSERT INTO migrations VALUES('149','2023_05_06_053255_create_trainers_table','1');
INSERT INTO migrations VALUES('150','2023_05_06_053256_create_training_types_table','1');
INSERT INTO migrations VALUES('151','2023_05_06_053257_create_training_lists_table','1');
INSERT INTO migrations VALUES('152','2023_05_06_053258_create_employee_training_list_table','1');
INSERT INTO migrations VALUES('153','2023_05_06_053259_create_employee_work_experience_table','1');
INSERT INTO migrations VALUES('154','2023_05_06_053260_create_events_table','1');
INSERT INTO migrations VALUES('155','2023_05_06_053261_create_expense_types_table','1');
INSERT INTO migrations VALUES('156','2023_05_06_053262_create_failed_jobs_table','1');
INSERT INTO migrations VALUES('157','2023_05_06_053263_create_file_manager_settings_table','1');
INSERT INTO migrations VALUES('158','2023_05_06_053265_create_file_managers_table','1');
INSERT INTO migrations VALUES('159','2023_05_06_053265_create_finance_bank_cashes_table','1');
INSERT INTO migrations VALUES('160','2023_05_06_053266_create_finance_payers_table','1');
INSERT INTO migrations VALUES('161','2023_05_06_053267_create_payment_methods_table','1');
INSERT INTO migrations VALUES('162','2023_05_06_053268_create_finance_deposits_table','1');
INSERT INTO migrations VALUES('163','2023_05_06_053269_create_finance_payees_table','1');
INSERT INTO migrations VALUES('164','2023_05_06_053270_create_finance_expenses_table','1');
INSERT INTO migrations VALUES('165','2023_05_06_053271_create_finance_transactions_table','1');
INSERT INTO migrations VALUES('166','2023_05_06_053272_create_finance_transfers_table','1');
INSERT INTO migrations VALUES('167','2023_05_06_053273_create_general_settings_table','1');
INSERT INTO migrations VALUES('168','2023_05_06_053274_create_goal_types_table','1');
INSERT INTO migrations VALUES('169','2023_05_06_053275_create_goal_trackings_table','1');
INSERT INTO migrations VALUES('170','2023_05_06_053276_create_holidays_table','1');
INSERT INTO migrations VALUES('171','2023_05_06_053277_create_indicators_table','1');
INSERT INTO migrations VALUES('172','2023_05_06_053278_create_invoices_table','1');
INSERT INTO migrations VALUES('173','2023_05_06_053279_create_invoice_items_table','1');
INSERT INTO migrations VALUES('174','2023_05_06_053280_create_ip_settings_table','1');
INSERT INTO migrations VALUES('175','2023_05_06_053281_create_job_candidates_table','1');
INSERT INTO migrations VALUES('176','2023_05_06_053282_create_leave_types_table','1');
INSERT INTO migrations VALUES('177','2023_05_06_053283_create_leaves_table','1');
INSERT INTO migrations VALUES('178','2023_05_06_053284_create_permissions_table','1');
INSERT INTO migrations VALUES('179','2023_05_06_053285_create_model_has_permissions_table','1');
INSERT INTO migrations VALUES('180','2023_05_06_053287_create_model_has_roles_table','1');
INSERT INTO migrations VALUES('181','2023_05_06_053288_create_notifications_table','1');
INSERT INTO migrations VALUES('182','2023_05_06_053289_create_official_documents_table','1');
INSERT INTO migrations VALUES('183','2023_05_06_053290_create_password_resets_table','1');
INSERT INTO migrations VALUES('184','2023_05_06_053291_create_payslips_table','1');
INSERT INTO migrations VALUES('185','2023_05_06_053292_create_policies_table','1');
INSERT INTO migrations VALUES('186','2023_05_06_053293_create_project_bugs_table','1');
INSERT INTO migrations VALUES('187','2023_05_06_053294_create_project_discussions_table','1');
INSERT INTO migrations VALUES('188','2023_05_06_053295_create_project_files_table','1');
INSERT INTO migrations VALUES('189','2023_05_06_053296_create_promotions_table','1');
INSERT INTO migrations VALUES('190','2023_05_06_053297_create_resignations_table','1');
INSERT INTO migrations VALUES('191','2023_05_06_053298_create_role_has_permissions_table','1');
INSERT INTO migrations VALUES('192','2023_05_06_053299_create_salary_allowances_table','1');
INSERT INTO migrations VALUES('193','2023_05_06_053300_create_salary_basics_table','1');
INSERT INTO migrations VALUES('194','2023_05_06_053301_create_salary_commissions_table','1');
INSERT INTO migrations VALUES('195','2023_05_06_053302_create_salary_deductions_table','1');
INSERT INTO migrations VALUES('196','2023_05_06_053303_create_salary_loans_table','1');
INSERT INTO migrations VALUES('197','2023_05_06_053304_create_salary_other_payments_table','1');
INSERT INTO migrations VALUES('198','2023_05_06_053305_create_salary_overtimes_table','1');
INSERT INTO migrations VALUES('199','2023_05_06_053306_create_task_discussions_table','1');
INSERT INTO migrations VALUES('200','2023_05_06_053307_create_task_files_table','1');
INSERT INTO migrations VALUES('201','2023_05_06_053308_create_tax_types_table','1');
INSERT INTO migrations VALUES('202','2023_05_06_053309_create_termination_types_table','1');
INSERT INTO migrations VALUES('203','2023_05_06_053310_create_terminations_table','1');
INSERT INTO migrations VALUES('204','2023_05_06_053311_create_ticket_comments_table','1');
INSERT INTO migrations VALUES('205','2023_05_06_053312_create_transfers_table','1');
INSERT INTO migrations VALUES('206','2023_05_06_053313_create_travel_types_table','1');
INSERT INTO migrations VALUES('207','2023_05_06_053314_create_travels_table','1');
INSERT INTO migrations VALUES('208','2023_05_06_053315_create_warnings_type_table','1');
INSERT INTO migrations VALUES('209','2023_05_06_053316_create_warnings_table','1');
INSERT INTO migrations VALUES('210','2023_05_06_053317_create_candidate_interview_table','1');
INSERT INTO migrations VALUES('211','2023_05_06_151650_delete_column_from_document_types_table','2');
INSERT INTO migrations VALUES('212','2023_05_06_153653_update_foreign_key_to_employees_table','2');
INSERT INTO migrations VALUES('213','2023_05_07_163304_update_foreign_key_to_projects_table','2');
INSERT INTO migrations VALUES('214','2023_05_08_004033_update_foreign_key_to_support_tickets_table','2');
INSERT INTO migrations VALUES('215','2023_05_08_094247_update_foreign_key_to_tasks_table','2');
INSERT INTO migrations VALUES('216','2023_05_08_101326_add_foreign_key_to_training_types_table','2');
INSERT INTO migrations VALUES('217','2023_05_08_152355_update_foreign_key_to_file_managers_table','2');
INSERT INTO migrations VALUES('218','2023_05_08_165246_update_foreign_key_to_payment_methods_table','2');
INSERT INTO migrations VALUES('219','2023_05_08_165419_update_foreign_key_to_finance_deposits_table','2');
INSERT INTO migrations VALUES('220','2023_05_09_112302_update_foreign_key_to_finance_expenses_table','2');
INSERT INTO migrations VALUES('221','2023_05_09_115226_update_foreign_key_to_finance_transactions_table','2');
INSERT INTO migrations VALUES('222','2023_05_09_122727_update_foreign_key_to_finance_transfers_table','2');
INSERT INTO migrations VALUES('223','2023_05_09_130054_add_foreign_key_to_goal_trackings_table','2');
INSERT INTO migrations VALUES('224','2023_05_09_134538_update_foreign_key_to_holidays_table','2');
INSERT INTO migrations VALUES('225','2023_05_09_134626_add_foreign_key_to_indicators_table','2');
INSERT INTO migrations VALUES('226','2023_05_09_134702_update_foreign_key_to_invoices_table','2');
INSERT INTO migrations VALUES('227','2023_05_09_134831_update_foreign_key_to_invoice_items_table','2');
INSERT INTO migrations VALUES('228','2023_05_09_162641_update_foreign_key_to_leaves_table','2');
INSERT INTO migrations VALUES('229','2023_05_09_181324_update_foreign_key_to_official_documents_table','2');
INSERT INTO migrations VALUES('230','2023_05_09_190434_update_foreign_key_to_policies_table','2');
INSERT INTO migrations VALUES('231','2023_05_09_193007_update_foreign_key_to_terminations_table','2');
INSERT INTO migrations VALUES('232','2023_05_09_195431_update_foreign_key_to_travel_types_table','2');
INSERT INTO migrations VALUES('233','2023_05_09_195925_update_foreign_key_to_travels_table','2');
INSERT INTO migrations VALUES('234','2023_05_09_200229_update_foreign_key_to_warnings_table','2');
INSERT INTO migrations VALUES('235','2023_08_02_113953_delete_company_id_column_to_training_types_table','2');
INSERT INTO migrations VALUES('236','2024_04_15_143831_add_column_to_users_table','3');
INSERT INTO migrations VALUES('238','2024_06_09_114933_create_company_types_table','4');
INSERT INTO migrations VALUES('239','2018_08_08_100000_create_telescope_entries_table','5');
INSERT INTO migrations VALUES('240','2024_05_13_123951_update_column_type_to_invoice_items_table','6');
INSERT INTO migrations VALUES('243','2024_07_22_184915_add_company_type_id_column_to_companies_table','7');
INSERT INTO migrations VALUES('244','2024_07_22_201241_create_relation_types_table','8');
INSERT INTO migrations VALUES('245','2024_07_22_230352_add_relation_type_id_column_to_employee_contacts_table','9');
INSERT INTO migrations VALUES('246','2024_07_23_091947_create_loan_types_table','10');
INSERT INTO migrations VALUES('248','2024_07_22_230356_add_loan_type_id_column_to_salary_loans_table','11');
INSERT INTO migrations VALUES('249','2024_07_23_113537_create_deduction_types_table','12');
INSERT INTO migrations VALUES('250','2024_07_22_230367_add_deduction_type_id_column_to_salary_loans_table','13');
INSERT INTO migrations VALUES('251','2024_07_23_201134_create_deposit_categories_table','14');
INSERT INTO migrations VALUES('252','2024_07_22_230368_add_deposit_category_id_column_to_finance_deposits_table','15');
INSERT INTO migrations VALUES('255','2024_07_22_230370_add_job_experience_id_column_to_job_posts_table','16');
INSERT INTO migrations VALUES('256','2024_07_28_140520_create_job_experiences_table','17');



CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO model_has_roles VALUES('1','App\\Models\\User','1');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','8');
INSERT INTO model_has_roles VALUES('6','App\\Models\\User','10');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','12');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','13');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','14');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','15');
INSERT INTO model_has_roles VALUES('5','App\\Models\\User','21');
INSERT INTO model_has_roles VALUES('5','App\\Models\\User','22');
INSERT INTO model_has_roles VALUES('4','App\\Models\\User','23');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','24');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','25');
INSERT INTO model_has_roles VALUES('4','App\\Models\\User','26');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','27');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','28');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','29');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','30');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','31');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','32');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','33');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','34');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','36');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','37');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','38');
INSERT INTO model_has_roles VALUES('3','App\\Models\\User','39');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','40');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','41');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','42');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','43');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','44');
INSERT INTO model_has_roles VALUES('4','App\\Models\\User','45');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','46');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','47');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','48');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','49');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','50');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','51');
INSERT INTO model_has_roles VALUES('3','App\\Models\\User','52');
INSERT INTO model_has_roles VALUES('3','App\\Models\\User','53');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','54');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','56');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','57');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','58');
INSERT INTO model_has_roles VALUES('2','App\\Models\\User','59');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','60');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','61');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','62');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','66');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','67');
INSERT INTO model_has_roles VALUES('1','App\\Models\\User','68');



CREATE TABLE `notifications` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notifications VALUES('001c271d-860c-45ff-9de3-44a6195de4a3','App\\Notifications\\EmployeeDocumentExpiryNotifyToAdmin','App\\User','51','{\"data\":\"A new notification about employee\'s document expiry\",\"link\":\"http:\\/\\/localhost\\/staff\\/employees\"}','','2023-01-23 11:08:18','2023-01-23 11:08:18');
INSERT INTO notifications VALUES('0096d6f3-aa02-453a-9bc2-225e366be5f3','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('00e7234c-517e-4b33-8eb4-0610ef967af3','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','47','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:09','2021-12-07 19:05:09');
INSERT INTO notifications VALUES('00fb92c0-4635-4a74-ac50-589b65768467','App\\Notifications\\CompanyPolicyNotify','App\\User','51','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('022e77a8-8ab7-4f54-8c07-96866a96cdc2','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','2022-06-05 13:44:54','2021-12-07 19:08:07','2022-06-05 13:44:54');
INSERT INTO notifications VALUES('025b43ad-33e6-4281-9424-dc882fd1bc5a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:19:41','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('03e11f54-3aff-4ff8-b7ff-096a58efd13e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO notifications VALUES('054584f3-fb46-4475-aa04-c3956e6542da','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('05f14b40-5501-4b98-8153-9dc0dcd8f583','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:42:55','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('0962bc16-0584-4f7d-9760-ad37a5f3c09d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('0ac4b300-c8ef-4fd5-9f38-a0eb71e05d6f','App\\Notifications\\ProjectUpdatedNotification','App\\User','8','{\"data\":\"Test1 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/1\"}','','2020-10-18 16:51:13','2020-10-18 16:51:13');
INSERT INTO notifications VALUES('0ac826c3-d95b-42c2-88a7-c70d1776379e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:43:20','2023-12-10 11:43:20');
INSERT INTO notifications VALUES('0b6fad58-df06-4c09-a154-bb5e3f767530','App\\Notifications\\TicketUpdatedNotification','App\\User','1','{\"data\":\"Issued ticket for Bob Hobart has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','2020-07-28 22:36:15','2020-07-28 22:36:02','2020-07-28 22:36:15');
INSERT INTO notifications VALUES('0c7b565d-2342-4937-8628-1db54d9a0642','App\\Notifications\\ProjectUpdatedNotification','App\\User','15','{\"data\":\"Test2 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/2\"}','','2020-10-25 22:42:46','2020-10-25 22:42:46');
INSERT INTO notifications VALUES('0ce84903-f200-42e8-acbf-9515393b20c2','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:14:57','2023-12-10 11:14:57');
INSERT INTO notifications VALUES('0d61497a-e239-408a-af8c-8396cb780b8f','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('11384293-8dee-431c-b884-3939819cc202','App\\Notifications\\LeaveNotification','App\\User','11','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','','2023-01-22 18:42:46','2023-01-22 18:42:46');
INSERT INTO notifications VALUES('1140572c-13d0-456b-b58e-01df812d21b6','App\\Notifications\\InvoicePaidNotification','App\\User','16','{\"data\":\"Payment of Project : Test2 has been paid\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/INV-NleUqw\"}','','2020-10-18 08:43:41','2020-10-18 08:43:41');
INSERT INTO notifications VALUES('120facb5-8691-454c-847b-1f3c2ad791a5','App\\Notifications\\ProjectCreatedNotifiaction','App\\User','51','{\"data\":\"A project has been created namely Test and 1 Employees has been assigned for \",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/project-management\\/projects\\/4\"}','','2023-02-09 10:32:21','2023-02-09 10:32:21');
INSERT INTO notifications VALUES('1432b73f-b57b-49bc-a620-da950457f5b6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:46:48','2023-12-10 11:46:48');
INSERT INTO notifications VALUES('144c0b47-e39d-4bb2-9742-0a1519d2a8b5','App\\Notifications\\InvoicePaidNotification','App\\User','16','{\"data\":\"Payment of Project : test3 has been paid\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/INV-IjAIYl\"}','','2020-10-12 13:20:56','2020-10-12 13:20:56');
INSERT INTO notifications VALUES('14b47e96-7736-494c-9bcf-ef50d6f66bd5','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 09:38:51','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('14d5f7d8-60fe-491a-85b8-334e78085f2a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('1713bde5-3d09-4ad5-9b10-ac43e0c9df05','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 13:56:43','2023-02-14 13:56:43');
INSERT INTO notifications VALUES('171e1fe6-13b0-4f89-bf95-a92392d4ba91','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:15:48','2023-12-10 11:15:48');
INSERT INTO notifications VALUES('17531917-73d0-4d40-af45-a2a663c71a94','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:46:45','2023-12-10 11:46:45');
INSERT INTO notifications VALUES('17c9ff3a-1b0f-4d32-96a4-be21653230cd','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO notifications VALUES('195ca03d-4cfb-4094-93f6-e2617e675fef','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','36','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:08','2021-12-07 19:05:08');
INSERT INTO notifications VALUES('19b514a6-e29a-4e9f-8c25-75d4429fb52e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('19f34faa-70dd-4c4b-abc8-3d79f63880b7','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('1ab2c4a7-078e-424e-ab48-80340fe3f7de','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:09','2021-10-04 06:51:09');
INSERT INTO notifications VALUES('1b525061-8395-4540-bbc2-7550f34c69a8','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO notifications VALUES('1bfb1701-e27c-4c38-9aa9-4c65f95edd53','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:01','2023-12-10 10:43:01');
INSERT INTO notifications VALUES('1c20d2b4-c861-466a-8dd1-0bfc4af880b3','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('1ebe500f-67aa-4dbb-a2ef-42edd1bace4a','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('1f355932-170d-439b-ae87-1f016c92faae','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','31','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('1fb3f81d-3bb5-4c24-94db-44e0cdda1072','App\\Notifications\\ProjectUpdatedNotification','App\\User','1','{\"data\":\"test3 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/3\"}','2021-06-17 08:44:26','2020-10-25 22:46:16','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('2026ebc5-e225-401f-a0e3-0f2304c46544','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:49:32','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('20c8e782-ea37-41ae-96d9-78c5f0ddd80c','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO notifications VALUES('20daa08e-b8bb-44bd-91e3-f42290570ce9','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:01','2021-10-04 09:39:01');
INSERT INTO notifications VALUES('20e9b7ff-4a38-4fae-b035-6db87cccd12d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:51:16','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('2173284b-75a0-4bc4-91f5-17ad34dcc7ed','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('228740fd-d259-4e86-91e4-9320df68b6b3','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:51:35','2023-12-10 11:51:35');
INSERT INTO notifications VALUES('229f3904-5c73-4763-8e99-6ac21e9d32b4','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','44','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('22ec1a2d-fc0b-4929-bac1-aeb61d7d9ad6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:55','2023-12-10 10:42:55');
INSERT INTO notifications VALUES('22ef0086-38ab-4db6-a3fc-152fcf7dd744','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:17:31','2023-12-10 11:17:31');
INSERT INTO notifications VALUES('232dbdbd-f4fc-4c6f-93ba-58d5f854e6b2','App\\Notifications\\TicketAssignedNotification','App\\User','12','{\"data\":\"2 Employees has been assigned for Bob Hobart ticket\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:35:30','2020-07-28 22:35:30');
INSERT INTO notifications VALUES('23d3ea31-9416-4a74-b53c-5062e2a23fef','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:51:16','2023-12-10 11:51:16');
INSERT INTO notifications VALUES('24dc0612-a560-41cb-a466-7dfd8fd648cd','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-10-04 06:47:04','2021-10-04 06:45:59','2021-10-04 06:47:04');
INSERT INTO notifications VALUES('26757a54-9f21-4369-828f-740b1f55efa8','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:14:35','2023-12-10 11:14:35');
INSERT INTO notifications VALUES('26fd9a32-861a-414f-bed9-656b04743199','App\\Notifications\\EmployeeTravelStatus','App\\User','9','{\"data\":\"Your travel request status is --- approved\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/profile#Employee_travel\"}','2021-07-05 21:23:34','2020-08-18 12:43:03','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('28e93542-4379-4216-9525-418e306719ea','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:43:46','2023-12-10 11:43:46');
INSERT INTO notifications VALUES('290cc4dc-26c8-4dbc-9397-f0ab4c7f359a','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:51','2021-10-04 09:38:51');
INSERT INTO notifications VALUES('29704e06-94fa-4fc3-a25f-4d9278a6fb61','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('29d227bd-8bc9-410d-801c-54f4a45c1cef','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','36','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('2aa1ad93-d742-4a72-bf58-8aeccf7ea38e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:13:15','2023-12-10 11:13:15');
INSERT INTO notifications VALUES('2adc0564-5f99-4835-b6c2-f03c02857210','App\\Notifications\\CompanyPolicyNotify','App\\User','38','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('2d728ddd-2c9c-4b94-9de7-722d59918397','App\\Notifications\\CompanyPolicyNotify','App\\User','9','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','2023-02-01 13:00:48','2023-02-01 13:00:21','2023-02-01 13:00:48');
INSERT INTO notifications VALUES('2d9f84f7-b18c-4d81-87e3-40ba55ed3ee1','App\\Notifications\\InvoiceReceivedNotification','App\\User','16','{\"data\":\"Invoice of Project : test3 has been received\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/INV-IjAIYl\"}','','2020-10-12 13:20:00','2020-10-12 13:20:00');
INSERT INTO notifications VALUES('2e761eb7-c74c-4254-9e5b-53989f1e5698','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:58:53','2023-12-10 11:58:53');
INSERT INTO notifications VALUES('2ed2f76d-2cdd-47c6-b6a8-307bc887ca9d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:46:45','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('2f0d94a5-5710-46c8-a6b2-166a4f0c8c1a','App\\Notifications\\LeaveNotification','App\\User','27','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','','2021-10-04 06:41:32','2021-10-04 06:41:32');
INSERT INTO notifications VALUES('304ed1b9-2c99-48da-9f36-98feba1341a4','App\\Notifications\\CompanyPolicyNotify','App\\User','49','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('308bdb65-0973-472f-bbc1-2150211d38dd','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('30f619b0-1a36-469e-9572-a24e7b121264','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 13:37:58','2023-02-14 13:37:58');
INSERT INTO notifications VALUES('316584ce-9135-4fb6-ab5f-8344025b051c','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('32123099-eeea-465e-9ff1-b6621c5ccc3a','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 09:39:04','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('322b32ae-935d-498e-b581-43235b332154','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('32881f2d-436b-4210-8570-3532e060a29b','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','46','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:08','2021-12-07 19:05:08');
INSERT INTO notifications VALUES('3386e315-ab4c-430f-af3c-86b128ff2966','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('3480c5be-9187-4d9d-8184-a9fcfedffc12','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:00','2021-10-04 09:39:00');
INSERT INTO notifications VALUES('37dc46f9-8b30-4682-96ec-57fe9c220532','App\\Notifications\\TicketCreatedNotification','App\\Models\\User','1','{\"data\":\"A ticket has been issued for Nitesh Yadav\",\"link\":\"https:\\/\\/learning.cbspd.com\\/peoplepro\\/tickets\\/JmQnjkLA\"}','2025-05-17 13:35:43','2025-05-17 13:35:24','2025-05-17 13:35:43');
INSERT INTO notifications VALUES('38310d31-a52b-4322-ae50-2feb80229870','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','44','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:08','2021-12-07 19:05:08');
INSERT INTO notifications VALUES('393c9aec-d382-483a-a6fc-743b21f71210','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:52','2021-10-04 09:38:52');
INSERT INTO notifications VALUES('399d6153-6aca-4952-8eed-54381d115624','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('3a3451e9-1ff2-45e9-b264-ead1f799f873','App\\Notifications\\EmployeeTravelStatus','App\\User','9','{\"data\":\"Your travel request status is --- approved\",\"link\":\"\\/profile#Employee_travel\"}','','2023-02-09 10:06:18','2023-02-09 10:06:18');
INSERT INTO notifications VALUES('3a45895d-f518-45ca-846f-2f5bf7fc94f4','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('3b1292dd-face-4085-abd7-c3efe75581d5','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:43:20','2023-12-10 11:43:20');
INSERT INTO notifications VALUES('3b99fa34-18bc-429a-8d74-ccb1fe15f74e','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('3c1a20d0-428b-4fb3-9be7-e698846f6a96','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:01','2023-12-10 10:43:01');
INSERT INTO notifications VALUES('3e33cf8b-f258-4a8e-9363-f016d99a221a','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','2022-06-05 13:44:54','2021-12-07 19:05:08','2022-06-05 13:44:54');
INSERT INTO notifications VALUES('3e623e9d-6b8a-4b72-aba8-7d2765db2a34','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('3f13c63d-9bb3-4460-b667-49cb0fd7b250','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('3fb66b15-8182-4333-8c26-c2719b2715f9','App\\Notifications\\LeaveNotificationToAdmin','App\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2023-01-22 19:21:34','2023-01-22 19:21:34');
INSERT INTO notifications VALUES('401a0b26-3678-4d0e-b8a4-8f12d023e071','App\\Notifications\\CompanyPolicyNotify','App\\User','13','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('416038b5-3c8f-427f-a2ba-cc2b89244b08','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:00','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('42c091e8-d723-496d-8719-f71903d1abba','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:52','2021-10-04 09:38:52');
INSERT INTO notifications VALUES('43bf5a15-d83b-45b2-9a39-99ee72b97b67','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('4451284a-bcea-48f5-9e8a-6a7ba7122df5','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO notifications VALUES('44afd540-9453-4b26-8d36-89039406aace','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 12:53:52','2023-02-14 12:53:52');
INSERT INTO notifications VALUES('45781ac7-43c5-4771-a8b9-4b7976ccb269','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:43:46','2023-12-10 11:43:46');
INSERT INTO notifications VALUES('45ef9b67-b88b-4267-baf7-933ea097b63a','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','51','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2023-01-23 11:46:37','2023-01-23 11:46:37');
INSERT INTO notifications VALUES('45f188d6-f41b-47e1-938a-7912090d9ce6','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','40','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('4643c917-18d1-4a33-a4f4-f460505a3d12','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('464c120c-cab8-4d3d-a296-b35a4c6ed0e9','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:47:21','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('4663aae6-f596-43e8-8e93-3915e6aeefcc','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:02','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('47b5d11c-c178-4a01-a460-2b482e6a557b','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('488d8395-47c2-4c23-807c-850cc25f1cd0','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:46:48','2023-12-10 11:46:48');
INSERT INTO notifications VALUES('499da8e2-f0ef-41e4-9961-4f1256fa6a18','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2023-04-25 09:30:23','2023-04-18 10:58:36','2023-04-25 09:30:23');
INSERT INTO notifications VALUES('4a92e6d8-d557-4331-9f3c-e4ed43cffd5e','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 13:49:38','2023-02-14 13:49:38');
INSERT INTO notifications VALUES('4b3cf8dc-e6f8-49e0-8223-29d99b1309fa','App\\Notifications\\LeaveNotification','App\\User','11','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','','2023-01-22 18:38:02','2023-01-22 18:38:02');
INSERT INTO notifications VALUES('4bb91dda-00f4-4a95-962b-48f372576446','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:14:57','2023-12-10 11:14:57');
INSERT INTO notifications VALUES('4c486763-4a00-4f67-a997-bcff253c887c','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 13:50:35','2023-02-14 13:50:35');
INSERT INTO notifications VALUES('4c64c79c-22c1-4242-bbe7-9935926a98d6','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','48','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('4c738d31-084d-451e-8349-7b198bbe8c22','App\\Notifications\\CompanyPolicyNotify','App\\User','15','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('4c9b05be-02ef-45eb-b8a6-d6cb4e1ac890','App\\Notifications\\ProjectUpdatedNotification','App\\User','9','{\"data\":\"Test1 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/1\"}','2021-07-05 21:23:34','2020-10-18 16:51:13','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('4eba0d1c-dc57-4f14-ac80-ca6613be48b3','App\\Notifications\\CompanyPolicyNotify','App\\User','45','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('4ebc622e-04c9-47a6-bca6-2fe8006e8900','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:10','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('4ed5c455-adf6-4003-9ac8-2827c6af237c','App\\Notifications\\CompanyPolicyNotify','App\\User','54','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('50073dea-e079-42bd-8c09-dacb4707daca','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('505d90a9-3bdd-4f6d-8564-a72facac8457','App\\Notifications\\AnnouncementPublished','App\\User','45','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('50983b79-7b63-4b55-bd68-67bf326b8ca8','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:15:48','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('547ad83e-f054-45d7-b9bd-fbcc030c0222','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2023-01-23 09:54:37','2023-01-22 19:22:39','2023-01-23 09:54:37');
INSERT INTO notifications VALUES('56a07a3b-d76c-46aa-8286-f26de328b01d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:55','2023-12-10 10:42:55');
INSERT INTO notifications VALUES('57dab3b7-4c79-4693-bf74-0652fce119bc','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('57f5e3b5-a5f6-4867-ba8c-bbf06119e588','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','46','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('58a29e2c-8f33-4f85-b54f-e457d689f2b0','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:01','2021-10-04 09:39:01');
INSERT INTO notifications VALUES('5b18bb54-f6de-40c9-a02b-d7641e18480d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('5b20b394-aeb6-4452-b528-ee240ebca04a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:13:15','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('5bcad5db-10b0-4864-93b3-239c540a0238','App\\Notifications\\ProjectUpdatedNotification','App\\User','12','{\"data\":\"Test1 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/1\"}','','2020-10-18 16:51:13','2020-10-18 16:51:13');
INSERT INTO notifications VALUES('5bf74554-7084-4547-be3b-8b73a17ac32a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('5f116526-e88b-478a-838d-9df709444e59','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:11','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('5f5ff17c-c9a9-4358-a197-6c9f331d0bbc','App\\Notifications\\TicketCreatedNotification','App\\Models\\User','51','{\"data\":\"A ticket has been issued for Nitesh Yadav\",\"link\":\"https:\\/\\/learning.cbspd.com\\/peoplepro\\/tickets\\/JmQnjkLA\"}','','2025-05-17 13:35:24','2025-05-17 13:35:24');
INSERT INTO notifications VALUES('61219cf8-71d3-4d0f-9a9d-0110847ae20c','App\\Notifications\\AnnouncementPublished','App\\User','13','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('641c1c91-d33c-451b-836f-c421e15912f7','App\\Notifications\\ClientTaskCreated','App\\User','8','{\"data\":\"A task has been created of Test2 by a client named maria_g\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/tasks\\/6\"}','','2020-10-12 07:23:23','2020-10-12 07:23:23');
INSERT INTO notifications VALUES('6477e425-daac-4112-a1c8-70a65560dc50','App\\Notifications\\EmployeeImmigrationExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about employee immigration expiry\",\"link\":\"http:\\/\\/localhost\\/staff\\/employees\"}','2023-01-29 10:24:27','2023-01-23 11:35:24','2023-01-29 10:24:27');
INSERT INTO notifications VALUES('6550982d-aec8-4fe4-a11c-c3b2c7d8d3a7','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('65d40c1a-7f70-46da-b019-0aac28e1d463','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','2023-01-29 10:24:27','2023-01-23 11:46:37','2023-01-29 10:24:27');
INSERT INTO notifications VALUES('66c824bf-2690-4148-b355-5648ce548f59','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:42:59','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('67298b26-e959-4220-bc84-e299299c6e0d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2023-01-22 19:22:39','2023-01-22 19:22:39');
INSERT INTO notifications VALUES('6740f5da-8ad7-46f5-b402-6b07e2931163','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('6783eb82-7334-4287-b8e2-829d199ca991','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','2023-01-29 10:24:27','2023-01-23 11:49:35','2023-01-29 10:24:27');
INSERT INTO notifications VALUES('67de7e0d-961f-4825-a210-ca0fdbab211b','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 12:58:23','2023-02-14 12:58:23');
INSERT INTO notifications VALUES('6824efa2-e711-4124-99ee-a53387550e7b','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('68794265-ead0-4050-ad4f-5bb6a5f17d59','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:09','2021-10-04 06:51:09');
INSERT INTO notifications VALUES('68b9c040-9c84-4a92-93a1-282635571730','App\\Notifications\\TicketAssignedNotification','App\\Models\\User','51','{\"data\":\"1 Employees has been assigned for Nitesh Yadav ticket\",\"link\":\"https:\\/\\/learning.cbspd.com\\/peoplepro\\/tickets\\/JmQnjkLA\"}','','2025-05-17 13:39:34','2025-05-17 13:39:34');
INSERT INTO notifications VALUES('68d675f4-986f-4175-8c53-5b2f9b1ac84f','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','36','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('69319850-8ca7-4734-8cd6-871d976077f1','App\\Notifications\\ProjectUpdatedNotification','App\\User','8','{\"data\":\"Test2 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/2\"}','','2020-10-25 22:42:46','2020-10-25 22:42:46');
INSERT INTO notifications VALUES('69670613-79ff-44d0-ac35-aa934afec828','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','51','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2023-01-23 11:49:35','2023-01-23 11:49:35');
INSERT INTO notifications VALUES('69d69625-5bfe-4ced-9a77-c778cf3af03e','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:01','2021-10-04 09:39:01');
INSERT INTO notifications VALUES('6a963963-d552-4340-a09b-14ba5680c21e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('6b204c85-682c-49c2-a083-2cc80b934c9c','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:15:48','2023-12-10 11:15:48');
INSERT INTO notifications VALUES('6bb25e6f-184c-4125-9f6e-796083f20406','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:09:20','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('6c2f2505-7f00-4170-848a-4fe5a7d8fffa','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:19:41','2023-12-10 11:19:41');
INSERT INTO notifications VALUES('6c88206a-2ef9-4b4e-b722-bbcc19b84446','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:08','2021-10-04 06:51:08');
INSERT INTO notifications VALUES('6d5b20d0-2fc6-45db-9fe1-8933875f1c0a','App\\Notifications\\ProjectCreatedNotifiaction','App\\User','1','{\"data\":\"A project has been created namely Test and 1 Employees has been assigned for \",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/project-management\\/projects\\/4\"}','2023-04-12 11:00:49','2023-02-09 10:32:21','2023-04-12 11:00:49');
INSERT INTO notifications VALUES('6dd2b0eb-2dd5-454e-929d-58b58442531b','App\\Notifications\\AnnouncementPublished','App\\User','57','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('6de1d6ee-c6f7-4d8e-a3fb-7731cad6d2de','App\\Notifications\\EmployeePromotion','App\\User','9','{\"data\":\" Congratulation!You have been promoted to  Senior Executive 1\",\"link\":\"\"}','2023-01-04 10:41:40','2023-01-04 10:41:32','2023-01-04 10:41:40');
INSERT INTO notifications VALUES('70aafa4e-434f-4ba2-8aea-ee754cce75c7','App\\Notifications\\TicketCreatedNotification','App\\User','1','{\"data\":\"A ticket has been issued for Bob Hobart\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','2020-07-28 22:35:45','2020-07-28 22:29:09','2020-07-28 22:35:45');
INSERT INTO notifications VALUES('71b6898f-6589-4d0e-91d8-f9009a26fccd','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:58:53','2023-12-10 11:58:53');
INSERT INTO notifications VALUES('72fa3405-572d-40ff-a76e-fc3ca7adbd6f','App\\Notifications\\TicketAssignedNotification','App\\Models\\User','1','{\"data\":\"1 Employees has been assigned for Nitesh Yadav ticket\",\"link\":\"https:\\/\\/learning.cbspd.com\\/peoplepro\\/tickets\\/JmQnjkLA\"}','2025-05-17 14:13:11','2025-05-17 13:39:34','2025-05-17 14:13:11');
INSERT INTO notifications VALUES('7391cd5f-0281-47df-9234-0220ca97ac5d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:57:17','2023-12-10 11:57:17');
INSERT INTO notifications VALUES('74f5ea51-fe94-483d-8325-f28075651289','App\\Notifications\\CompanyPolicyNotify','App\\User','14','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('7533d3e8-9950-40aa-a25e-1c95e0af4204','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','40','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:08','2021-12-07 19:05:08');
INSERT INTO notifications VALUES('757ae95d-6c33-4a59-9968-5d36dc0af936','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:01','2021-10-04 09:39:01');
INSERT INTO notifications VALUES('75865d0f-944d-43e2-aa43-ab1ad12a6e92','App\\Notifications\\TicketCreatedNotification','App\\User','12','{\"data\":\"A ticket has been issued for Bob Hobart\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:29:09','2020-07-28 22:29:09');
INSERT INTO notifications VALUES('76e6c668-831f-42c4-b1ad-1bf94eef70ed','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:52','2021-10-04 09:38:52');
INSERT INTO notifications VALUES('773781f5-10f9-4e99-a01c-362cdc650fc6','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('77a66edc-80ca-4b78-83b5-62e88edc7181','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('7914f808-738f-4453-9a28-843a4c1a5951','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 09:39:00','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('795b9487-6bab-4c5d-99b4-f856f136dd38','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:09','2021-10-04 06:51:09');
INSERT INTO notifications VALUES('79cf2205-e643-4220-9374-6111b9b3825c','App\\Notifications\\AnnouncementPublished','App\\User','9','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('7abf44af-96a4-4816-b418-bd3170f74ec7','App\\Notifications\\EmployeeDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about employee\'s document expiry\",\"link\":\"http:\\/\\/localhost\\/staff\\/employees\"}','2023-01-29 10:24:27','2023-01-23 11:08:18','2023-01-29 10:24:27');
INSERT INTO notifications VALUES('7ad86074-a47d-4312-aaeb-a075655d523a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('7b38e007-e61a-4c18-9cc8-0d072e65df31','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 06:51:08','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('7b62222c-0e8a-4a07-bf25-19c02e4e3631','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:49:32','2023-12-10 11:49:32');
INSERT INTO notifications VALUES('7c58da93-c6cc-4073-92a3-24af280b8010','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('7c8e157a-7150-4e6d-b162-a9296f35a5d0','App\\Notifications\\ProjectCreatedNotifiaction','App\\User','9','{\"data\":\"A project has been created namely Test and 1 Employees has been assigned for \",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/project-management\\/projects\\/4\"}','','2023-02-09 10:32:21','2023-02-09 10:32:21');
INSERT INTO notifications VALUES('7cebe6a4-fcee-441a-a8cb-56419afefb48','App\\Notifications\\EmployeeImmigrationExpiryNotifyToAdmin','App\\User','51','{\"data\":\"A new notification about employee immigration expiry\",\"link\":\"http:\\/\\/localhost\\/staff\\/employees\"}','','2023-01-23 11:35:24','2023-01-23 11:35:24');
INSERT INTO notifications VALUES('7d2802a2-6c28-480f-8ab9-69b1b8e48a20','App\\Notifications\\ProjectUpdatedNotification','App\\User','1','{\"data\":\"test3 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/3\"}','2021-06-17 08:44:26','2020-10-25 22:44:23','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('7fbad02a-1fb1-485d-a451-6c5c8be10824','App\\Notifications\\ClientTaskCreated','App\\User','1','{\"data\":\"A task has been created of Test2 by a client named maria_g\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/tasks\\/6\"}','2021-06-17 08:44:26','2020-10-12 07:23:23','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('80ac7dbf-bf4f-4934-abbf-e90f74abf649','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:09:20','2023-12-10 11:09:20');
INSERT INTO notifications VALUES('80b934e0-ccb0-4ddc-a3ea-764f8938718a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:46:48','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('83068985-5441-40f4-9ef6-4d1cf4dc5ff8','App\\Notifications\\AnnouncementPublished','App\\User','54','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('84dc4732-bbd9-43de-a4bc-f923f27d7294','App\\Notifications\\AnnouncementPublished','App\\User','51','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('85a290fa-06ea-453b-b116-1d70ffbd8145','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:52','2021-10-04 09:38:52');
INSERT INTO notifications VALUES('864f5ce3-8379-4c7f-9fcc-1925d9c474cf','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('8889e6b7-f697-415d-b930-3a822be0ae20','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:43:46','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('89e46bdf-1373-44e0-a61c-8b950126a3bf','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','1','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','2022-06-05 13:44:54','2021-12-07 19:08:23','2022-06-05 13:44:54');
INSERT INTO notifications VALUES('8a7a3452-282b-4110-9c71-5c067d3bc781','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:03','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('8ace70d8-ccad-4bcf-a48b-b3266107bf42','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('8b291e66-2f25-4baa-9a4a-95186bc63bdb','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('8bde6e2c-1b75-4e64-8af2-2a3c8aca5723','App\\Notifications\\AnnouncementPublished','App\\User','38','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('8c6c6b32-bbd8-46f6-bbf4-3ceb9892cd66','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 13:55:42','2023-02-14 13:55:42');
INSERT INTO notifications VALUES('8d5c0651-030f-4d23-9041-7904bbedc072','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','40','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('8e1da56e-c9b7-4886-a795-291a7944f044','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:08','2021-10-04 06:51:08');
INSERT INTO notifications VALUES('8e9054a1-fe5d-4a8b-8b33-40655f1306bf','App\\Notifications\\EmployeeAwardNotify','App\\User','9','{\"data\":\"Congratulation! An Award has been given to you\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/profile#Employee_Core_hr\"}','2021-07-05 21:23:34','2020-08-18 12:25:40','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('8fc8f7b0-8bbf-4f02-aeba-29198e055b13','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:11','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('90cfd472-af51-43fe-92e5-3a8c5266a942','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:09','2021-10-04 06:51:09');
INSERT INTO notifications VALUES('925e15c2-da0a-4f40-80f8-61398bc5c885','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:03','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('93cc9392-a981-41b8-8b56-50ef40b47db0','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:09:20','2023-12-10 11:09:20');
INSERT INTO notifications VALUES('94454ac0-c2b4-4511-af4e-a3bff878c7f8','App\\Notifications\\LeaveNotificationToAdmin','App\\User','31','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:00','2021-10-04 09:39:00');
INSERT INTO notifications VALUES('9783fa27-2b69-4628-84c8-d841ad97dbbd','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:49:32','2023-12-10 11:49:32');
INSERT INTO notifications VALUES('97de5f4e-3da8-4126-ad12-29894d2d1009','App\\Notifications\\AnnouncementPublished','App\\User','34','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('98bb4245-0f9a-4a21-84c5-ab5d44904cc7','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:10','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('9a2c3218-774f-4990-b41b-f5ba0d5dad5a','App\\Notifications\\TicketUpdatedNotification','App\\User','8','{\"data\":\"Issued ticket for Bob Hobart has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:36:02','2020-07-28 22:36:02');
INSERT INTO notifications VALUES('9b2fa86f-db94-4694-84be-2c033bbb450d','App\\Notifications\\TicketAssignedNotification','App\\User','8','{\"data\":\"2 Employees has been assigned for Bob Hobart ticket\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:35:30','2020-07-28 22:35:30');
INSERT INTO notifications VALUES('9c7ef9db-ad32-46c9-a1ce-269a127b41e9','App\\Notifications\\CompanyPolicyNotify','App\\User','12','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('9ce4f9b2-698e-4b79-be29-8572c0c2d6f6','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:00','2021-10-04 09:39:00');
INSERT INTO notifications VALUES('9d42de54-e758-4c1b-89ab-5e48df006967','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:11','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('9e5de11c-c9fd-4b3d-acd5-dc2208b46682','App\\Notifications\\EmployeeTravelStatus','App\\User','9','{\"data\":\"Your travel request status is --- first level approval\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/profile#Employee_travel\"}','2021-07-05 21:23:34','2020-08-18 12:41:23','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('9fe492ca-7b37-4419-935d-31cd42d3af77','App\\Notifications\\ClientTaskCreated','App\\User','8','{\"data\":\"new2222 has been updated by a client named maria_g\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/tasks\\/6\"}','','2020-10-12 07:30:20','2020-10-12 07:30:20');
INSERT INTO notifications VALUES('a2943799-2fc3-402b-97b2-d5c290cd189d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:00','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('a3530a24-01fe-4553-9a32-18866781408d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:18:20','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('a40b5530-584d-4044-a7e9-7d084458868e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:13:15','2023-12-10 11:13:15');
INSERT INTO notifications VALUES('a4149d71-fda4-4df1-a9af-8e69f317181d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:51','2021-10-04 09:38:51');
INSERT INTO notifications VALUES('a45dcc68-9faf-4e84-9c1e-109433953c52','App\\Notifications\\EmployeeTerminationNotify','App\\User','54','{\"data\":\"You have been terminated from this company  Termination Date-- 14-02-2023\",\"link\":\"\"}','','2023-02-14 12:18:05','2023-02-14 12:18:05');
INSERT INTO notifications VALUES('a4b6b7c9-d8a9-433c-bd3d-7afc27c4e8d7','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('a4e7e18f-ee7f-4534-8dd4-9220d85ea62f','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:14:57','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('a526d3da-a48a-4148-83fe-7039a0925d28','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('a692f74e-dfc2-445d-ae44-50f4f0225fb1','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 06:52:12','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('a6ef60fe-a7fe-423b-85d8-cd49a8f2236d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-10-04 06:47:04','2021-10-04 06:46:18','2021-10-04 06:47:04');
INSERT INTO notifications VALUES('a7f0d2ae-9c0e-4864-afe3-45e0b153a8f6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:14:35','2023-12-10 11:14:35');
INSERT INTO notifications VALUES('a92e54de-6aa5-4f9e-84ff-db58c857ce6e','App\\Notifications\\ProjectUpdatedNotification','App\\User','11','{\"data\":\"Test1 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/1\"}','','2020-10-18 16:51:13','2020-10-18 16:51:13');
INSERT INTO notifications VALUES('aa98a0bc-377f-4a1e-8c0a-bb07427e34b6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:43:20','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('ab2e4808-6c93-4da8-8f4d-fb815ba785af','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('abd9f143-9495-4d48-8a0b-889c0939bfce','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('adacadc8-0fcd-4b16-98b3-799ed0e41b11','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','46','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('adf75e6d-d5ea-4cbf-b0c8-2e076aa25e32','App\\Notifications\\AnnouncementPublished','App\\User','49','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('af53a0b7-fcf3-4a5d-acd2-a80f4980b212','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('af7d233c-a70f-4ec9-b21e-8103515f9fa2','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('afc5b977-35bc-4907-898f-c13cedea5815','App\\Notifications\\AnnouncementPublished','App\\User','27','{\"data\":\"A new announcement has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/announcements\"}','','2023-05-02 12:42:00','2023-05-02 12:42:00');
INSERT INTO notifications VALUES('b0e5a738-ff48-4c14-a02a-2ad571ce0fa6','App\\Notifications\\InvoiceReceivedNotification','App\\User','16','{\"data\":\"Invoice of Project : Test2 has been received\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/INV-NleUqw\"}','','2020-10-18 08:48:53','2020-10-18 08:48:53');
INSERT INTO notifications VALUES('b1e3b1af-51e7-4971-b10d-bfd6da509f06','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:51:35','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('b2b60f8f-7a96-491e-b4db-a7b162b042f6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:51:16','2023-12-10 11:51:16');
INSERT INTO notifications VALUES('b4394ab6-4dec-430f-92d8-a25fe5dae37d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:51:08','2021-10-04 06:51:08');
INSERT INTO notifications VALUES('b72dcc7f-1134-418f-85c2-847fed5b369d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('b8f87453-1177-4edf-8fc4-4969e2a8d122','App\\Notifications\\ProjectUpdatedNotification','App\\User','14','{\"data\":\"Test2 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/2\"}','','2020-10-25 22:42:46','2020-10-25 22:42:46');
INSERT INTO notifications VALUES('baed268a-08f6-4c19-a19a-2e3805ca16d6','App\\Notifications\\InvoiceReceivedNotification','App\\User','16','{\"data\":\"Invoice of Project : Test2 has been received\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/INV-NleUqw\"}','','2020-10-18 09:03:04','2020-10-18 09:03:04');
INSERT INTO notifications VALUES('bc610769-a549-4f72-968d-a1205afb0222','App\\Notifications\\LeaveNotificationToAdmin','App\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2023-04-18 10:58:36','2023-04-18 10:58:36');
INSERT INTO notifications VALUES('bcc9843f-0c01-4627-94f2-29690dfa4686','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:17:31','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('bcdd73f6-8799-4c10-861a-0cb2b87e64d1','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('bd2bb9a5-aca5-494b-8de8-6870ab3aaf9d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('bd671f1e-eef8-4cde-93b2-a73bcca47872','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:02','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('bd7c7126-de39-46c4-a9d6-fc5855df4dfa','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:47:21','2023-12-10 11:47:21');
INSERT INTO notifications VALUES('bf2d32ac-a272-47f2-836a-b009d401f92b','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:00','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('bf455597-1022-4ac9-a3aa-587c4024b3ad','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2023-01-23 09:54:37','2023-01-22 19:21:34','2023-01-23 09:54:37');
INSERT INTO notifications VALUES('c1011c75-3b8e-4c03-9a22-e1b0ce9eb8cf','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('c14d50a8-90b3-42fc-ace1-41c73b16489c','App\\Notifications\\TicketAssignedNotification','App\\User','10','{\"data\":\"2 Employees has been assigned for Bob Hobart ticket\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:35:30','2020-07-28 22:35:30');
INSERT INTO notifications VALUES('c28dbc06-1294-46bf-8f6f-72f63047b948','App\\Notifications\\CompanyPolicyNotify','App\\User','34','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('c313047d-d3e9-42f3-b3d2-d7e0aabc331c','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:42:59','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('c373f767-038a-498d-8832-e5e01831b90a','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO notifications VALUES('c6a47158-f02c-4d44-b96d-543c53edf66a','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','48','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:09','2021-12-07 19:05:09');
INSERT INTO notifications VALUES('c83164d5-9c5d-430d-b1db-8b0df31b3222','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:11','2023-12-10 10:43:11');
INSERT INTO notifications VALUES('ca5edf4d-5eae-41fe-a549-a8eb99e917a6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:10','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('caed272e-87ec-47ea-ae2c-bb515fe992e3','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('cbd8d62e-7758-4224-91e1-6a84d12c00fd','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','31','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:05:08','2021-12-07 19:05:08');
INSERT INTO notifications VALUES('cc135169-a6a2-480e-9f58-fe29dee5e36d','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:17','2021-10-04 09:39:17');
INSERT INTO notifications VALUES('cce1e2ee-35c5-4fc6-b835-0e31e0b6562c','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('cd0bf547-0c7e-4c03-a3d0-01de7f908dc0','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:46:45','2023-12-10 11:46:45');
INSERT INTO notifications VALUES('ce2db6e9-e1bd-4bc7-b3bd-ad9691d5d866','App\\Notifications\\InterviewHostNotification','App\\Models\\User','9','{\"data\":\"You have been selected as an interview host\\nInterview Title: Laravel Developer\\nInterview Date & Time: 17-11-2023|03:00PM\\nPlease set a reminder.\",\"link\":\"\"}','','2023-11-15 15:10:32','2023-11-15 15:10:32');
INSERT INTO notifications VALUES('ce7e603c-e115-413d-9f14-1d0c2809b75b','App\\Notifications\\LeaveNotificationToAdmin','App\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','2021-11-27 11:12:22','2021-10-04 09:39:17','2021-11-27 11:12:22');
INSERT INTO notifications VALUES('ced1e972-39db-4f13-aaed-8fe492e03947','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','48','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('cf7d4b40-9d91-4431-a780-0abe6abd13ae','App\\Notifications\\InvoicePaidNotification','App\\User','16','{\"data\":\"Test1 has been paid\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/1\"}','2020-10-12 10:38:12','2020-10-12 10:35:30','2020-10-12 10:38:12');
INSERT INTO notifications VALUES('cfd90a21-c28a-4e5a-b0c7-5c60703c47da','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:45:59','2021-10-04 06:45:59');
INSERT INTO notifications VALUES('d0b5259d-71ec-4937-8e6d-50d217491718','App\\Notifications\\TicketAssignedNotification','App\\User','9','{\"data\":\"2 Employees has been assigned for Bob Hobart ticket\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','2021-07-05 21:23:34','2020-07-28 22:35:30','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('d1c48fa1-d34d-4ef3-a702-6558503c8e97','App\\Notifications\\CompanyPolicyNotify','App\\User','11','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('d1f085ce-f949-4d31-abee-1babd42615e8','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:02','2023-12-10 10:43:02');
INSERT INTO notifications VALUES('d29fed5b-da28-4cfd-a9e7-f5648188a750','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:42:59','2023-12-10 10:42:59');
INSERT INTO notifications VALUES('d2a9da67-9c33-413e-b66b-4fffaca5aa0e','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('d3618620-305e-4c5e-9413-b3313600d80d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('d45ac590-d192-442b-afa3-66117f4bb2ec','App\\Notifications\\InvoiceReceivedNotification','App\\User','16','{\"data\":\"Invoice of Project : test3 has been received\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/invoices\\/4\"}','','2020-10-12 12:58:36','2020-10-12 12:58:36');
INSERT INTO notifications VALUES('d547f33d-e08c-447c-9db8-129b1f1f82a2','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','44','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('d678bab5-47c1-4ff8-8152-2c92ad954858','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('d69e4610-2282-4cab-892d-ab9a8ec12377','App\\Notifications\\LeaveNotificationToAdmin','App\\User','36','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('d6bb80f0-8168-429c-ab79-e26e0bfd8d20','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('d6c06da9-cde1-492b-8a6c-7d37f7619039','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:03','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('dae8114f-054f-4283-85f9-50cd017f16c3','App\\Notifications\\LeaveNotification','App\\User','9','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','2023-02-01 13:00:48','2023-01-22 18:38:58','2023-02-01 13:00:48');
INSERT INTO notifications VALUES('db3fe78e-ae71-41bd-8922-f485b5a788c7','App\\Notifications\\LeaveNotificationToAdmin','App\\User','44','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('dc742fb8-d1dd-4825-89f7-446dabab1cf0','App\\Notifications\\LeaveNotificationToAdmin','App\\User','48','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:39:05','2021-10-04 09:39:05');
INSERT INTO notifications VALUES('dd7d8a82-9530-421b-9851-2d32080d6641','App\\Notifications\\InterviewHostNotification','App\\Models\\User','9','{\"data\":\"You have been selected as an interview host\\nInterview Title: Laravel Developer\\nInterview Date & Time: 18-11-2023|03:00PM\\nPlease set a reminder.\",\"link\":\"\"}','','2023-11-15 22:54:40','2023-11-15 22:54:40');
INSERT INTO notifications VALUES('e13ca350-d4c4-4d3b-9388-b531f1fc641f','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:18:20','2023-12-10 11:18:20');
INSERT INTO notifications VALUES('e1efd771-c8d7-407e-b853-6c6cff2b39c2','App\\Notifications\\InterviewHostNotification','App\\Models\\User','11','{\"data\":\"You have been selected as an interview host\\nInterview Title: Laravel Developer\\nInterview Date & Time: 17-11-2023|03:00PM\\nPlease set a reminder.\",\"link\":\"\"}','','2023-11-15 15:10:32','2023-11-15 15:10:32');
INSERT INTO notifications VALUES('e1f793a3-1ed5-468a-a9dd-9d2e0ce3f960','App\\Notifications\\EmployeeTerminationNotify','App\\User','40','{\"data\":\"You have been terminated from this company  Termination Date-- 16-12-2021\",\"link\":\"\"}','','2021-12-15 11:36:11','2021-12-15 11:36:11');
INSERT INTO notifications VALUES('e2e65835-cf70-42c8-9d53-c505f81bb347','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:57:17','2023-12-10 11:57:17');
INSERT INTO notifications VALUES('e31d9ddc-b7e6-439d-bc31-bdb8d7ca100b','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:00','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('e3b8524c-573e-4b8e-9465-7789189c5224','App\\Notifications\\EmployeePromotion','App\\User','9','{\"data\":\" Congratulation!You have been promoted to  Senior Executive 1\",\"link\":\"\"}','2021-07-05 21:23:34','2020-08-18 12:15:52','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('e5bcedba-c599-4b37-b64d-3999e637ef07','App\\Notifications\\LeaveNotification','App\\User','9','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','2023-02-01 13:00:48','2023-01-22 18:35:34','2023-02-01 13:00:48');
INSERT INTO notifications VALUES('e64200a7-67c7-4a50-afa2-d85a611f94e4','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:17:31','2023-12-10 11:17:31');
INSERT INTO notifications VALUES('e7faff2c-21f2-49a4-917a-b7c4f0c41b85','App\\Notifications\\EmployeeTransferNotify','App\\User','9','{\"data\":\"You have been transferred To\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/profile#Employee_transfer\"}','2021-07-05 21:23:34','2020-08-18 13:14:56','2021-07-05 21:23:34');
INSERT INTO notifications VALUES('e82fc7b5-2ab7-4799-af55-204684deb53f','App\\Notifications\\ProjectUpdatedNotification','App\\User','8','{\"data\":\"test3 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/3\"}','','2020-10-25 22:46:16','2020-10-25 22:46:16');
INSERT INTO notifications VALUES('e8ef14ff-2fe5-4d4d-84f7-17ff19f83dc6','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:03','2023-12-10 10:43:03');
INSERT INTO notifications VALUES('eac4e6ff-a002-488d-83dd-a44128ab8be7','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:00','2023-12-10 10:43:00');
INSERT INTO notifications VALUES('eb39757d-ea53-4cb1-bfb4-126dd2c044a9','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:01','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('ec32bc86-7300-4509-b28a-1b91e2e99711','App\\Notifications\\ProjectUpdatedNotification','App\\User','8','{\"data\":\"test3 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/3\"}','','2020-10-25 22:44:23','2020-10-25 22:44:23');
INSERT INTO notifications VALUES('ec517324-8a08-46cd-8bcc-e381809474b5','App\\Notifications\\ClientTaskCreated','App\\User','1','{\"data\":\"new2222 has been updated by a client named maria_g\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/tasks\\/6\"}','2021-06-17 08:44:26','2020-10-12 07:30:20','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('ec5dd162-e289-4e27-9ada-0f48b67a71cf','App\\Notifications\\EmployeePromotion','App\\Models\\User','59','{\"data\":\" Congratulation!You have been promoted to  WEB\",\"link\":\"\"}','2025-05-17 15:12:56','2025-05-17 15:12:39','2025-05-17 15:12:56');
INSERT INTO notifications VALUES('ecc3dc35-43c0-4f70-9704-c6abf6300464','App\\Notifications\\ProjectUpdatedNotification','App\\User','1','{\"data\":\"Test2 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/2\"}','2021-06-17 08:44:26','2020-10-25 22:42:46','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('ed5e044a-30b4-434d-b88b-4fce4f03bc43','App\\Notifications\\CompanyPolicyNotify','App\\User','27','{\"data\":\"Company Policy has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/organization\\/policy\"}','','2023-02-01 13:00:21','2023-02-01 13:00:21');
INSERT INTO notifications VALUES('ed8a63b0-3c36-4acc-9235-ec3636a11b95','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:57:17','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('ed994f46-e157-4ed1-8a8a-1f15120c7845','App\\Notifications\\TicketAssignedNotification','App\\User','1','{\"data\":\"2 Employees has been assigned for Bob Hobart ticket\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','2020-07-28 22:35:45','2020-07-28 22:35:30','2020-07-28 22:35:45');
INSERT INTO notifications VALUES('ee103974-8f7c-4054-b2bb-d26961d15b0b','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','47','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('ef653d39-343e-4af3-99b5-9c2d9c94941f','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:11','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('efe59846-7051-407f-9db0-f52d065a2c29','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:14:35','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('f4e9fe25-dad1-44a7-8812-d065639d2e42','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','31','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:07','2021-12-07 19:08:07');
INSERT INTO notifications VALUES('f5a68bdd-6431-42cf-8baa-5b166146c290','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 10:43:00','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('f5bca5b5-9c10-4222-a977-85e2b83aed64','App\\Notifications\\InterviewHostNotification','App\\Models\\User','9','{\"data\":\"You have been selected as an interview host\\nInterview Title: Laravel Developer\\nInterview Date & Time: 16-11-2023|03:00PM\\nPlease set a reminder.\",\"link\":\"\"}','','2023-11-15 22:44:29','2023-11-15 22:44:29');
INSERT INTO notifications VALUES('f69f0707-2803-4c0e-8d30-134272ac9637','App\\Notifications\\LeaveNotificationToAdmin','App\\User','40','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 09:38:52','2021-10-04 09:38:52');
INSERT INTO notifications VALUES('f6b8fafd-1e8e-4519-b7ea-c0eb8d894f0c','App\\Notifications\\LeaveNotificationToAdmin','App\\User','47','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:52:12','2021-10-04 06:52:12');
INSERT INTO notifications VALUES('f6f34a1a-bb5f-4e44-b0ce-5f1e389e84f1','App\\Notifications\\LeaveNotificationToAdmin','App\\User','46','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/timesheet\\/leaves\"}','','2021-10-04 06:46:18','2021-10-04 06:46:18');
INSERT INTO notifications VALUES('f746d414-0eda-4377-9592-8f118906c841','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 10:43:10','2023-12-10 10:43:10');
INSERT INTO notifications VALUES('f7b7f0bc-87c5-47de-815c-0da9d6912884','App\\Notifications\\ProjectUpdatedNotification','App\\User','1','{\"data\":\"Test1 has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/project-management\\/projects\\/1\"}','2021-06-17 08:44:26','2020-10-18 16:51:13','2021-06-17 08:44:26');
INSERT INTO notifications VALUES('f86d68e0-1f30-4149-820a-be970a73f920','App\\Notifications\\LeaveNotification','App\\User','11','{\"data\":\"A new leave-notification has been published\",\"link\":\"http:\\/\\/localhost\\/peoplepro\\/profile#Leave\"}','','2023-01-22 19:01:00','2023-01-22 19:01:00');
INSERT INTO notifications VALUES('fa1c5825-43e9-4ee9-a48d-792f43b0d79d','App\\Notifications\\TicketUpdatedNotification','App\\User','12','{\"data\":\"Issued ticket for Bob Hobart has been updated\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:36:02','2020-07-28 22:36:02');
INSERT INTO notifications VALUES('fafa293c-59d1-4a5e-8543-bc5c68f6bc07','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:18:20','2023-12-10 11:18:20');
INSERT INTO notifications VALUES('fc357a40-ae27-4527-a58d-ff76767d94b7','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:47:21','2023-12-10 11:47:21');
INSERT INTO notifications VALUES('fd8f2436-1abb-4d71-af1a-b8b104891862','App\\Notifications\\OfficialDocumentExpiryNotifyToAdmin','App\\User','47','{\"data\":\"A new notification about official document expiry\",\"link\":\"http:\\/\\/localhost\\/file_manager\\/official_documents\"}','','2021-12-07 19:08:23','2021-12-07 19:08:23');
INSERT INTO notifications VALUES('fddcacf7-2aa7-46e6-bb8a-f5afc134e82d','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','1','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','2024-01-16 08:52:08','2023-12-10 11:58:53','2024-01-16 08:52:08');
INSERT INTO notifications VALUES('fea68d3b-bf7b-452f-b3de-d41d30a787ec','App\\Notifications\\TicketCreatedNotification','App\\User','8','{\"data\":\"A ticket has been issued for Bob Hobart\",\"link\":\"http:\\/\\/peopleprohrm.com\\/demo\\/tickets\\/Kkqx8gSB\"}','','2020-07-28 22:29:09','2020-07-28 22:29:09');
INSERT INTO notifications VALUES('fea88b58-5878-4f9b-925d-d407d95d8672','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','9','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:51:35','2023-12-10 11:51:35');
INSERT INTO notifications VALUES('ffdfe8cd-e146-4ce5-844b-87e6a641e4ad','App\\Notifications\\LeaveNotificationToAdmin','App\\Models\\User','51','{\"data\":\"A new leave-notification\",\"link\":\"http:\\/\\/peopleprohrm.test\\/timesheet\\/leaves\"}','','2023-12-10 11:19:41','2023-12-10 11:19:41');



CREATE TABLE `office_shifts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_shift` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` bigint unsigned NOT NULL,
  `sunday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sunday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saturday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saturday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `friday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `friday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thursday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thursday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wednesday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wednesday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tuesday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tuesday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monday_in` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monday_out` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `office_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `office_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO office_shifts VALUES('3','PPG','','11','','','10:00AM','06:00PM','10:00AM','06:00PM','10:00AM','06:00PM','10:00AM','06:00PM','10:00AM','06:00PM','10:00AM','06:00PM','2025-05-16 13:41:18','2025-05-16 13:41:59');



CREATE TABLE `official_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `document_type_id` bigint unsigned DEFAULT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  `document_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `identification_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `document_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `official_documents_company_id_foreign` (`company_id`),
  KEY `official_documents_document_type_id_foreign` (`document_type_id`),
  KEY `official_documents_added_by_foreign` (`added_by`),
  CONSTRAINT `official_documents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `official_documents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `official_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO official_documents VALUES('1','1','3','1','Bay Project Info','8739320','','Bay Project Info.1603366355.pdf','2023-01-30','7','2020-10-22 14:02:35','2023-01-23 11:43:36');



CREATE TABLE `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO password_resets VALUES('new@gmail.com','$2y$10$day4AQ4g8sFvMwhMrTxpJuLXZCpVF2IK9kVS.6qZxeR6b7CVt2eGy','2020-10-06 09:52:35');
INSERT INTO password_resets VALUES('irfanchowdhury80@gmail.com','$2y$10$3Opuz3k6NY0WRJbDgHO8gOz2UlR4GOumTVsQgu61.mPbmzt8DnYi6','2024-01-14 13:43:48');
INSERT INTO password_resets VALUES('irfanchowdhury434@gmail.com','$2y$10$Xzahp1UflMrb3lzE/C9lQeGQ0z.E9UoA.1XjW7KRLIuuwTGdfp.NS','2024-03-31 12:48:22');



CREATE TABLE `payment_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `method_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_percentage` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_methods VALUES('2','','Bank','5%','786','2020-07-27 09:23:17','2020-07-27 09:23:17');
INSERT INTO payment_methods VALUES('3','','Cash','2%%','999','2020-07-27 09:23:29','2023-11-07 12:09:23');



CREATE TABLE `payslips` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payslip_key` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payslip_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `company_id` bigint unsigned NOT NULL,
  `payment_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `basic_salary` double NOT NULL,
  `net_salary` double NOT NULL,
  `allowances` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `commissions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `loans` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deductions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtimes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `other_payments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pension_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pension_amount` double NOT NULL,
  `hours_worked` int NOT NULL,
  `status` tinyint NOT NULL,
  `month_year` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payslips_employee_id_foreign` (`employee_id`),
  CONSTRAINT `payslips_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payslips VALUES('153','MojiX0BrB2nPkGB8GLEo','9462137854','11','1','Hourly','100','1615','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Home\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2020-07-29 22:10:53\",\"updated_at\":\"2020-07-29 22:10:53\"},{\"id\":2,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Tea\",\"allowance_amount\":\"50\",\"is_taxable\":0,\"created_at\":\"2020-07-30 00:08:42\",\"updated_at\":\"2020-07-30 00:08:42\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"3\",\"amount_remaining\":\"75\",\"monthly_payable\":\"25.000\"}]','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"deduction_title\":\"Test\",\"deduction_amount\":\"10\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2020-07-30 00:21:22\",\"updated_at\":\"2020-07-30 00:21:22\"}]','[]','[]','','0','14','1','March-2021','2021-04-12 23:03:37','2021-04-12 23:03:37');
INSERT INTO payslips VALUES('154','tSGyONwrlCeMjeWOemTl','5146547430','11','1','Hourly','100','215','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Home\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2020-07-29 22:10:53\",\"updated_at\":\"2020-07-29 22:10:53\"},{\"id\":2,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Tea\",\"allowance_amount\":\"50\",\"is_taxable\":0,\"created_at\":\"2020-07-30 00:08:42\",\"updated_at\":\"2020-07-30 00:08:42\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"2\",\"amount_remaining\":\"50\",\"monthly_payable\":\"25.000\"}]','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"deduction_title\":\"Test\",\"deduction_amount\":\"10\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2020-07-30 00:21:22\",\"updated_at\":\"2020-07-30 00:21:22\"}]','[]','[]','','0','0','1','April-2021','2021-04-12 23:04:45','2021-04-12 23:04:45');
INSERT INTO payslips VALUES('155','02fZCnP2WZPMvoAe03C7','3205941835','11','1','Hourly','100','215','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Home\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2020-07-29 22:10:53\",\"updated_at\":\"2020-07-29 22:10:53\"},{\"id\":2,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Tea\",\"allowance_amount\":\"50\",\"is_taxable\":0,\"created_at\":\"2020-07-30 00:08:42\",\"updated_at\":\"2020-07-30 00:08:42\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"1\",\"amount_remaining\":\"25\",\"monthly_payable\":\"25.000\"}]','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"deduction_title\":\"Test\",\"deduction_amount\":\"10\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2020-07-30 00:21:22\",\"updated_at\":\"2020-07-30 00:21:22\"}]','[]','[]','','0','0','1','May-2021','2021-04-12 23:05:23','2021-04-12 23:05:23');
INSERT INTO payslips VALUES('156','VIM8lgr0qjgan1fJyOZJ','5926261822','11','1','Hourly','100','215','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Home\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2020-07-29 22:10:53\",\"updated_at\":\"2020-07-29 22:10:53\"},{\"id\":2,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Tea\",\"allowance_amount\":\"50\",\"is_taxable\":0,\"created_at\":\"2020-07-30 00:08:42\",\"updated_at\":\"2020-07-30 00:08:42\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"25.000\"}]','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"deduction_title\":\"Test\",\"deduction_amount\":\"10\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2020-07-30 00:21:22\",\"updated_at\":\"2020-07-30 00:21:22\"}]','[]','[]','','0','0','1','June-2021','2021-04-12 23:06:32','2021-04-12 23:06:32');
INSERT INTO payslips VALUES('167','tHhQ0sudoHhVhDRfIpya','4457156927','11','1','Hourly','100','740','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Home\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2020-07-29 09:10:53\",\"updated_at\":\"2020-07-29 09:10:53\"},{\"id\":2,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"allowance_title\":\"Tea\",\"allowance_amount\":\"50\",\"is_taxable\":0,\"created_at\":\"2020-07-29 11:08:42\",\"updated_at\":\"2020-07-29 11:08:42\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"0\"}]','[{\"id\":1,\"employee_id\":11,\"month_year\":\"January-2021\",\"first_date\":\"2021-01-01\",\"deduction_title\":\"Test\",\"deduction_amount\":\"10\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2020-07-29 11:21:22\",\"updated_at\":\"2020-07-29 11:21:22\"}]','[]','[]','','0','5','1','July-2021','2021-07-03 19:18:19','2021-07-03 19:18:19');
INSERT INTO payslips VALUES('168','N7ZSEkNPJzeAXwP93juf','6468694689','9','1','Monthly','500','350','[{\"id\":15,\"employee_id\":9,\"month_year\":\"August-2021\",\"first_date\":\"2021-08-01\",\"allowance_title\":\"Milk\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2021-04-09 11:38:21\",\"updated_at\":\"2021-04-09 11:38:21\"}]','[]','[]','[{\"id\":10,\"employee_id\":9,\"month_year\":\"April-2021\",\"first_date\":\"2021-04-01\",\"deduction_title\":\"Fever\",\"deduction_amount\":\"100\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2021-04-10 19:16:30\",\"updated_at\":\"2021-04-10 19:16:30\"}]','[]','[]','percentage','250','0','1','July-2022','2022-07-23 13:45:27','2022-07-23 13:45:27');
INSERT INTO payslips VALUES('169','zGxSMPfXaZPQTLq4V0PJ','8615826435','11','1','Monthly','100','70','[{\"id\":16,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"allowance_title\":\"Transportation\",\"allowance_amount\":\"10\",\"is_taxable\":0,\"created_at\":\"2022-10-18 10:17:19\",\"updated_at\":\"2022-10-18 10:17:19\"},{\"id\":17,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"allowance_title\":\"Communication\",\"allowance_amount\":\"10\",\"is_taxable\":0,\"created_at\":\"2022-10-18 10:17:44\",\"updated_at\":\"2022-10-18 10:17:44\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"0\"},{\"id\":9,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"50\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"50.00\"}]','[{\"id\":11,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"deduction_title\":\"Medical\",\"deduction_amount\":\"15\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2022-10-18 10:19:18\",\"updated_at\":\"2022-10-18 10:19:18\"}]','[{\"id\":14,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"overtime_title\":\"OT\",\"no_of_days\":\"4\",\"overtime_hours\":\"8\",\"overtime_rate\":\"0.5\",\"overtime_amount\":\"4\",\"created_at\":\"2022-10-18 10:20:06\",\"updated_at\":\"2022-10-18 10:20:06\"}]','[{\"id\":5,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"other_payment_title\":\"Reimbursement\",\"other_payment_amount\":\"11\",\"created_at\":\"2022-10-18 10:19:39\",\"updated_at\":\"2022-10-18 10:19:39\"}]','','0','0','1','October-2022','2022-10-18 20:52:39','2022-10-18 20:52:39');
INSERT INTO payslips VALUES('188','bFzWbHiPmtwzu6NMLNmU','5850643090','9','1','Monthly','500','350','[{\"id\":15,\"employee_id\":9,\"month_year\":\"August-2021\",\"first_date\":\"2021-08-01\",\"allowance_title\":\"Milk\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2021-04-09T05:38:21.000000Z\",\"updated_at\":\"2021-04-09T05:38:21.000000Z\"}]','[]','[]','[{\"id\":10,\"employee_id\":9,\"month_year\":\"April-2021\",\"first_date\":\"2021-04-01\",\"deduction_title\":\"Fever\",\"deduction_amount\":\"100\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2021-04-10T13:16:30.000000Z\",\"updated_at\":\"2021-04-10T13:16:30.000000Z\"}]','[]','[]','percentage','250','0','1','April-2023','2023-04-15 10:48:37','2023-04-15 10:48:37');
INSERT INTO payslips VALUES('189','D0Fbmb5URYblJ02QWudb','6507747581','11','1','Monthly','100','55','[{\"id\":16,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"allowance_title\":\"Transportation\",\"allowance_amount\":\"10\",\"is_taxable\":0,\"created_at\":\"2022-10-18T15:17:19.000000Z\",\"updated_at\":\"2022-10-18T15:17:19.000000Z\"},{\"id\":17,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"allowance_title\":\"Communication\",\"allowance_amount\":\"10\",\"is_taxable\":0,\"created_at\":\"2022-10-18T15:17:44.000000Z\",\"updated_at\":\"2022-10-18T15:17:44.000000Z\"}]','[]','[{\"id\":8,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"100\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"0\"},{\"id\":9,\"employee_id\":11,\"loan_title\":\"Home\",\"loan_amount\":\"50\",\"time_remaining\":\"0\",\"amount_remaining\":\"0\",\"monthly_payable\":\"0\"}]','[{\"id\":11,\"employee_id\":11,\"month_year\":\"October-2022\",\"first_date\":\"2022-10-01\",\"deduction_title\":\"Medical\",\"deduction_amount\":\"15\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2022-10-18T15:19:18.000000Z\",\"updated_at\":\"2022-10-18T15:19:18.000000Z\"}]','[]','[]','','0','0','1','April-2023','2023-04-15 13:28:00','2023-04-15 13:28:00');
INSERT INTO payslips VALUES('190','va6pNUvcHDIQ8AgfpucE','4322269479','9','1','Monthly','500','350','[{\"id\":15,\"employee_id\":9,\"month_year\":\"August-2021\",\"first_date\":\"2021-08-01\",\"allowance_title\":\"Milk\",\"allowance_amount\":\"200\",\"is_taxable\":0,\"created_at\":\"2021-04-09T06:08:21.000000Z\",\"updated_at\":\"2021-04-09T06:08:21.000000Z\"}]','[]','[]','[{\"id\":10,\"employee_id\":9,\"month_year\":\"April-2021\",\"first_date\":\"2021-04-01\",\"deduction_title\":\"Fever\",\"deduction_amount\":\"100\",\"deduction_type\":\"Health Insurance Corporation\",\"created_at\":\"2021-04-10T13:46:30.000000Z\",\"updated_at\":\"2021-04-10T13:46:30.000000Z\"}]','[]','[]','percentage','250','0','1','September-2023','2023-09-12 10:09:32','2023-09-12 10:09:32');
INSERT INTO payslips VALUES('193','9EEm0z1Pr7HQm9xTOxtb','1399298206','59','11','Monthly','58544','95773','[{\"id\":18,\"employee_id\":\"59\",\"month_year\":\"May-2025\",\"first_date\":\"2025-05-01\",\"allowance_title\":\"HRA\",\"allowance_amount\":\"29272\",\"is_taxable\":\"1\",\"created_at\":\"2025-05-22T09:49:00.000000Z\",\"updated_at\":\"2025-05-22T09:49:00.000000Z\"},{\"id\":19,\"employee_id\":\"59\",\"month_year\":\"May-2025\",\"first_date\":\"2025-05-01\",\"allowance_title\":\"CCA\",\"allowance_amount\":\"9757\",\"is_taxable\":\"1\",\"created_at\":\"2025-05-22T09:51:34.000000Z\",\"updated_at\":\"2025-05-22T09:51:34.000000Z\"},{\"id\":20,\"employee_id\":\"59\",\"month_year\":\"May-2025\",\"first_date\":\"2025-05-01\",\"allowance_title\":\"PF\",\"allowance_amount\":\"1800\",\"is_taxable\":\"0\",\"created_at\":\"2025-05-22T09:54:47.000000Z\",\"updated_at\":\"2025-05-22T09:54:47.000000Z\"}]','[]','[]','[{\"id\":15,\"employee_id\":\"59\",\"month_year\":\"May-2025\",\"first_date\":\"2025-05-01\",\"deduction_title\":\"PF\",\"deduction_amount\":\"1800\",\"deduction_type_id\":\"8\",\"created_at\":\"2025-05-22T08:56:07.000000Z\",\"updated_at\":\"2025-05-22T09:55:27.000000Z\"}]','[]','[]','fixed','1800','0','1','May-2025','2025-05-22 15:29:31','2025-05-22 15:29:31');



CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('1','user','web','','');
INSERT INTO permissions VALUES('2','view-user','web','','');
INSERT INTO permissions VALUES('3','edit-user','web','','');
INSERT INTO permissions VALUES('4','delete-user','web','','');
INSERT INTO permissions VALUES('5','last-login-user','web','','');
INSERT INTO permissions VALUES('6','role-access-user','web','','');
INSERT INTO permissions VALUES('7','details-employee','web','','');
INSERT INTO permissions VALUES('8','view-details-employee','web','','');
INSERT INTO permissions VALUES('9','store-details-employee','web','','');
INSERT INTO permissions VALUES('10','modify-details-employee','web','','');
INSERT INTO permissions VALUES('11','customize-setting','web','','');
INSERT INTO permissions VALUES('12','role-access','web','','');
INSERT INTO permissions VALUES('13','general-setting','web','','');
INSERT INTO permissions VALUES('14','view-general-setting','web','','');
INSERT INTO permissions VALUES('15','store-general-setting','web','','');
INSERT INTO permissions VALUES('16','mail-setting','web','','');
INSERT INTO permissions VALUES('17','view-mail-setting','web','','');
INSERT INTO permissions VALUES('18','store-mail-setting','web','','');
INSERT INTO permissions VALUES('19','language-setting','web','','');
INSERT INTO permissions VALUES('20','core_hr','web','','');
INSERT INTO permissions VALUES('21','view-calendar','web','','');
INSERT INTO permissions VALUES('22','promotion','web','','');
INSERT INTO permissions VALUES('23','view-promotion','web','','');
INSERT INTO permissions VALUES('24','store-promotion','web','','');
INSERT INTO permissions VALUES('25','edit-promotion','web','','');
INSERT INTO permissions VALUES('26','delete-promotion','web','','');
INSERT INTO permissions VALUES('27','award','web','','');
INSERT INTO permissions VALUES('28','view-award','web','','');
INSERT INTO permissions VALUES('29','store-award','web','','');
INSERT INTO permissions VALUES('30','edit-award','web','','');
INSERT INTO permissions VALUES('31','delete-award','web','','');
INSERT INTO permissions VALUES('32','transfer','web','','');
INSERT INTO permissions VALUES('33','view-transfer','web','','');
INSERT INTO permissions VALUES('34','store-transfer','web','','');
INSERT INTO permissions VALUES('35','edit-transfer','web','','');
INSERT INTO permissions VALUES('36','delete-transfer','web','','');
INSERT INTO permissions VALUES('37','travel','web','','');
INSERT INTO permissions VALUES('38','view-travel','web','','');
INSERT INTO permissions VALUES('39','store-travel','web','','');
INSERT INTO permissions VALUES('40','edit-travel','web','','');
INSERT INTO permissions VALUES('41','delete-travel','web','','');
INSERT INTO permissions VALUES('42','resignation','web','','');
INSERT INTO permissions VALUES('43','view-resignation','web','','');
INSERT INTO permissions VALUES('44','store-resignation','web','','');
INSERT INTO permissions VALUES('45','edit-resignation','web','','');
INSERT INTO permissions VALUES('46','delete-resignation','web','','');
INSERT INTO permissions VALUES('47','complaint','web','','');
INSERT INTO permissions VALUES('48','view-complaint','web','','');
INSERT INTO permissions VALUES('49','store-complaint','web','','');
INSERT INTO permissions VALUES('50','edit-complaint','web','','');
INSERT INTO permissions VALUES('51','delete-complaint','web','','');
INSERT INTO permissions VALUES('52','warning','web','','');
INSERT INTO permissions VALUES('53','view-warning','web','','');
INSERT INTO permissions VALUES('54','store-warning','web','','');
INSERT INTO permissions VALUES('55','edit-warning','web','','');
INSERT INTO permissions VALUES('56','delete-warning','web','','');
INSERT INTO permissions VALUES('57','termination','web','','');
INSERT INTO permissions VALUES('58','view-termination','web','','');
INSERT INTO permissions VALUES('59','store-termination','web','','');
INSERT INTO permissions VALUES('60','edit-termination','web','','');
INSERT INTO permissions VALUES('61','delete-termination','web','','');
INSERT INTO permissions VALUES('62','timesheet','web','','');
INSERT INTO permissions VALUES('63','attendance','web','','');
INSERT INTO permissions VALUES('64','view-attendance','web','','');
INSERT INTO permissions VALUES('65','edit-attendance','web','','');
INSERT INTO permissions VALUES('66','office_shift','web','','');
INSERT INTO permissions VALUES('67','view-office_shift','web','','');
INSERT INTO permissions VALUES('68','store-office_shift','web','','');
INSERT INTO permissions VALUES('69','edit-office_shift','web','','');
INSERT INTO permissions VALUES('70','delete-office_shift','web','','');
INSERT INTO permissions VALUES('71','holiday','web','','');
INSERT INTO permissions VALUES('72','view-holiday','web','','');
INSERT INTO permissions VALUES('73','store-holiday','web','','');
INSERT INTO permissions VALUES('74','edit-holiday','web','','');
INSERT INTO permissions VALUES('75','delete-holiday','web','','');
INSERT INTO permissions VALUES('76','leave','web','','');
INSERT INTO permissions VALUES('77','view-holiday','web','','');
INSERT INTO permissions VALUES('78','store-holiday','web','','');
INSERT INTO permissions VALUES('79','edit-holiday','web','','');
INSERT INTO permissions VALUES('80','delete-holiday','web','','');
INSERT INTO permissions VALUES('81','payment-module','web','','');
INSERT INTO permissions VALUES('82','view-payslip','web','','');
INSERT INTO permissions VALUES('83','make-payment','web','','');
INSERT INTO permissions VALUES('84','make-bulk_payment','web','','');
INSERT INTO permissions VALUES('85','view-paylist','web','','');
INSERT INTO permissions VALUES('86','set-salary','web','','');
INSERT INTO permissions VALUES('87','hr_report','web','','');
INSERT INTO permissions VALUES('88','report-payslip','web','','');
INSERT INTO permissions VALUES('89','report-attendance','web','','');
INSERT INTO permissions VALUES('90','report-training','web','','');
INSERT INTO permissions VALUES('91','report-project','web','','');
INSERT INTO permissions VALUES('92','report-task','web','','');
INSERT INTO permissions VALUES('93','report-employee','web','','');
INSERT INTO permissions VALUES('94','report-account','web','','');
INSERT INTO permissions VALUES('95','report-deposit','web','','');
INSERT INTO permissions VALUES('96','report-expense','web','','');
INSERT INTO permissions VALUES('97','report-transaction','web','','');
INSERT INTO permissions VALUES('98','recruitment','web','','');
INSERT INTO permissions VALUES('99','job_employer','web','','');
INSERT INTO permissions VALUES('100','view-job_employer','web','','');
INSERT INTO permissions VALUES('101','store-job_employer','web','','');
INSERT INTO permissions VALUES('102','edit-job_employer','web','','');
INSERT INTO permissions VALUES('103','delete-job_employer','web','','');
INSERT INTO permissions VALUES('104','job_post','web','','');
INSERT INTO permissions VALUES('105','view-job_post','web','','');
INSERT INTO permissions VALUES('106','store-job_post','web','','');
INSERT INTO permissions VALUES('107','edit-job_post','web','','');
INSERT INTO permissions VALUES('108','delete-job_post','web','','');
INSERT INTO permissions VALUES('109','job_candidate','web','','');
INSERT INTO permissions VALUES('110','view-job_candidate','web','','');
INSERT INTO permissions VALUES('111','store-job_candidate','web','','');
INSERT INTO permissions VALUES('112','delete-job_candidate','web','','');
INSERT INTO permissions VALUES('113','job_interview','web','','');
INSERT INTO permissions VALUES('114','view-job_interview','web','','');
INSERT INTO permissions VALUES('115','store-job_interview','web','','');
INSERT INTO permissions VALUES('116','delete-job_interview','web','','');
INSERT INTO permissions VALUES('117','project-management','web','','');
INSERT INTO permissions VALUES('118','project','web','','');
INSERT INTO permissions VALUES('119','view-project','web','','');
INSERT INTO permissions VALUES('120','store-project','web','','');
INSERT INTO permissions VALUES('121','edit-project','web','','');
INSERT INTO permissions VALUES('122','delete-project','web','','');
INSERT INTO permissions VALUES('123','task','web','','');
INSERT INTO permissions VALUES('124','view-task','web','','');
INSERT INTO permissions VALUES('125','store-task','web','','');
INSERT INTO permissions VALUES('126','edit-task','web','','');
INSERT INTO permissions VALUES('127','delete-task','web','','');
INSERT INTO permissions VALUES('128','client','web','','');
INSERT INTO permissions VALUES('129','view-client','web','','');
INSERT INTO permissions VALUES('130','store-client','web','','');
INSERT INTO permissions VALUES('131','edit-client','web','','');
INSERT INTO permissions VALUES('132','delete-client','web','','');
INSERT INTO permissions VALUES('133','invoice','web','','');
INSERT INTO permissions VALUES('134','view-invoice','web','','');
INSERT INTO permissions VALUES('135','store-invoice','web','','');
INSERT INTO permissions VALUES('136','edit-invoice','web','','');
INSERT INTO permissions VALUES('137','delete-invoice','web','','');
INSERT INTO permissions VALUES('138','ticket','web','','');
INSERT INTO permissions VALUES('139','view-ticket','web','','');
INSERT INTO permissions VALUES('140','store-ticket','web','','');
INSERT INTO permissions VALUES('141','edit-ticket','web','','');
INSERT INTO permissions VALUES('142','delete-ticket','web','','');
INSERT INTO permissions VALUES('143','import-module','web','','');
INSERT INTO permissions VALUES('144','import-attendance','web','','');
INSERT INTO permissions VALUES('145','import-employee','web','','');
INSERT INTO permissions VALUES('146','file_module','web','','');
INSERT INTO permissions VALUES('147','file_manager','web','','');
INSERT INTO permissions VALUES('148','view-file_manager','web','','');
INSERT INTO permissions VALUES('149','store-file_manager','web','','');
INSERT INTO permissions VALUES('150','edit-file_manager','web','','');
INSERT INTO permissions VALUES('151','delete-file_manager','web','','');
INSERT INTO permissions VALUES('152','view-file_config','web','','');
INSERT INTO permissions VALUES('153','official_document','web','','');
INSERT INTO permissions VALUES('154','view-official_document','web','','');
INSERT INTO permissions VALUES('155','store-official_document','web','','');
INSERT INTO permissions VALUES('156','edit-official_document','web','','');
INSERT INTO permissions VALUES('157','delete-official_document','web','','');
INSERT INTO permissions VALUES('158','event-meeting','web','','');
INSERT INTO permissions VALUES('159','meeting','web','','');
INSERT INTO permissions VALUES('160','view-meeting','web','','');
INSERT INTO permissions VALUES('161','store-meeting','web','','');
INSERT INTO permissions VALUES('162','edit-meeting','web','','');
INSERT INTO permissions VALUES('163','delete-meeting','web','','');
INSERT INTO permissions VALUES('164','event','web','','');
INSERT INTO permissions VALUES('165','view-event','web','','');
INSERT INTO permissions VALUES('166','store-event','web','','');
INSERT INTO permissions VALUES('167','edit-event','web','','');
INSERT INTO permissions VALUES('168','delete-event','web','','');
INSERT INTO permissions VALUES('169','role','web','','');
INSERT INTO permissions VALUES('170','view-role','web','','');
INSERT INTO permissions VALUES('171','store-role','web','','');
INSERT INTO permissions VALUES('172','edit-role','web','','');
INSERT INTO permissions VALUES('173','delete-role','web','','');
INSERT INTO permissions VALUES('174','assign-module','web','','');
INSERT INTO permissions VALUES('175','assign-role','web','','');
INSERT INTO permissions VALUES('176','assign-ticket','web','','');
INSERT INTO permissions VALUES('177','assign-project','web','','');
INSERT INTO permissions VALUES('178','assign-task','web','','');
INSERT INTO permissions VALUES('179','finance','web','','');
INSERT INTO permissions VALUES('180','account','web','','');
INSERT INTO permissions VALUES('181','view-account','web','','');
INSERT INTO permissions VALUES('182','store-account','web','','');
INSERT INTO permissions VALUES('183','edit-account','web','','');
INSERT INTO permissions VALUES('184','delete-account','web','','');
INSERT INTO permissions VALUES('185','view-transaction','web','','');
INSERT INTO permissions VALUES('186','view-balance_transfer','web','','');
INSERT INTO permissions VALUES('187','store-balance_transfer','web','','');
INSERT INTO permissions VALUES('188','expense','web','','');
INSERT INTO permissions VALUES('189','view-expense','web','','');
INSERT INTO permissions VALUES('190','store-expense','web','','');
INSERT INTO permissions VALUES('191','edit-expense','web','','');
INSERT INTO permissions VALUES('192','delete-expense','web','','');
INSERT INTO permissions VALUES('193','deposit','web','','');
INSERT INTO permissions VALUES('194','view-deposit','web','','');
INSERT INTO permissions VALUES('195','store-deposit','web','','');
INSERT INTO permissions VALUES('196','edit-deposit','web','','');
INSERT INTO permissions VALUES('197','delete-deposit','web','','');
INSERT INTO permissions VALUES('198','payer','web','','');
INSERT INTO permissions VALUES('199','view-payer','web','','');
INSERT INTO permissions VALUES('200','store-payer','web','','');
INSERT INTO permissions VALUES('201','edit-payer','web','','');
INSERT INTO permissions VALUES('202','delete-payer','web','','');
INSERT INTO permissions VALUES('203','payee','web','','');
INSERT INTO permissions VALUES('204','view-payee','web','','');
INSERT INTO permissions VALUES('205','store-payee','web','','');
INSERT INTO permissions VALUES('206','edit-payee','web','','');
INSERT INTO permissions VALUES('207','delete-payee','web','','');
INSERT INTO permissions VALUES('208','training_module','web','','');
INSERT INTO permissions VALUES('209','trainer','web','','');
INSERT INTO permissions VALUES('210','view-trainer','web','','');
INSERT INTO permissions VALUES('211','store-trainer','web','','');
INSERT INTO permissions VALUES('212','edit-trainer','web','','');
INSERT INTO permissions VALUES('213','delete-trainer','web','','');
INSERT INTO permissions VALUES('214','training','web','','');
INSERT INTO permissions VALUES('215','view-training','web','','');
INSERT INTO permissions VALUES('216','store-training','web','','');
INSERT INTO permissions VALUES('217','edit-training','web','','');
INSERT INTO permissions VALUES('218','delete-training','web','','');
INSERT INTO permissions VALUES('219','access-module','web','','');
INSERT INTO permissions VALUES('220','access-variable_type','web','','');
INSERT INTO permissions VALUES('221','access-variable_method','web','','');
INSERT INTO permissions VALUES('222','access-language','web','','');
INSERT INTO permissions VALUES('223','announcement','web','','');
INSERT INTO permissions VALUES('224','store-announcement','web','','');
INSERT INTO permissions VALUES('225','edit-announcement','web','','');
INSERT INTO permissions VALUES('226','delete-announcement','web','','');
INSERT INTO permissions VALUES('227','company','web','','');
INSERT INTO permissions VALUES('228','view-company','web','','');
INSERT INTO permissions VALUES('229','store-company','web','','');
INSERT INTO permissions VALUES('230','edit-company','web','','');
INSERT INTO permissions VALUES('231','delete-company','web','','');
INSERT INTO permissions VALUES('232','department','web','','');
INSERT INTO permissions VALUES('233','view-department','web','','');
INSERT INTO permissions VALUES('234','store-department','web','','');
INSERT INTO permissions VALUES('235','edit-department','web','','');
INSERT INTO permissions VALUES('236','delete-department','web','','');
INSERT INTO permissions VALUES('237','designation','web','','');
INSERT INTO permissions VALUES('238','view-designation','web','','');
INSERT INTO permissions VALUES('239','store-designation','web','','');
INSERT INTO permissions VALUES('240','edit-designation','web','','');
INSERT INTO permissions VALUES('241','delete-designation','web','','');
INSERT INTO permissions VALUES('242','location','web','','');
INSERT INTO permissions VALUES('243','view-location','web','','');
INSERT INTO permissions VALUES('244','store-location','web','','');
INSERT INTO permissions VALUES('245','edit-location','web','','');
INSERT INTO permissions VALUES('246','delete-location','web','','');
INSERT INTO permissions VALUES('247','policy','web','','');
INSERT INTO permissions VALUES('248','store-policy','web','','');
INSERT INTO permissions VALUES('249','edit-policy','web','','');
INSERT INTO permissions VALUES('250','delete-policy','web','','');
INSERT INTO permissions VALUES('251','view-cms','web','','');
INSERT INTO permissions VALUES('252','store-cms','web','','');
INSERT INTO permissions VALUES('253','store-user','web','','');
INSERT INTO permissions VALUES('254','delete-attendance','web','','');
INSERT INTO permissions VALUES('255','view-leave','web','','');
INSERT INTO permissions VALUES('256','store-leave','web','','');
INSERT INTO permissions VALUES('257','edit-leave','web','','');
INSERT INTO permissions VALUES('258','delete-leave','web','','');
INSERT INTO permissions VALUES('259','cms','web','','');
INSERT INTO permissions VALUES('260','performance','web','','');
INSERT INTO permissions VALUES('261','goal-type','web','','');
INSERT INTO permissions VALUES('262','view-goal-type','web','','');
INSERT INTO permissions VALUES('263','store-goal-type','web','','');
INSERT INTO permissions VALUES('264','edit-goal-type','web','','');
INSERT INTO permissions VALUES('265','delete-goal-type','web','','');
INSERT INTO permissions VALUES('266','goal-tracking','web','','');
INSERT INTO permissions VALUES('267','view-goal-tracking','web','','');
INSERT INTO permissions VALUES('268','store-goal-tracking','web','','');
INSERT INTO permissions VALUES('269','edit-goal-tracking','web','','');
INSERT INTO permissions VALUES('270','delete-goal-tracking','web','','');
INSERT INTO permissions VALUES('271','indicator','web','','');
INSERT INTO permissions VALUES('272','view-indicator','web','','');
INSERT INTO permissions VALUES('273','store-indicator','web','','');
INSERT INTO permissions VALUES('274','edit-indicator','web','','');
INSERT INTO permissions VALUES('275','delete-indicator','web','','');
INSERT INTO permissions VALUES('276','appraisal','web','','');
INSERT INTO permissions VALUES('277','view-appraisal','web','','');
INSERT INTO permissions VALUES('278','store-appraisal','web','','');
INSERT INTO permissions VALUES('279','edit-appraisal','web','','');
INSERT INTO permissions VALUES('280','delete-appraisal','web','','');
INSERT INTO permissions VALUES('281','assets-and-category','web','','');
INSERT INTO permissions VALUES('282','category','web','','');
INSERT INTO permissions VALUES('283','view-assets-category','web','','');
INSERT INTO permissions VALUES('284','store-assets-category','web','','');
INSERT INTO permissions VALUES('285','edit-assets-category','web','','');
INSERT INTO permissions VALUES('286','delete-assets-category','web','','');
INSERT INTO permissions VALUES('287','assets','web','','');
INSERT INTO permissions VALUES('288','view-assets','web','','');
INSERT INTO permissions VALUES('289','store-assets','web','','');
INSERT INTO permissions VALUES('290','edit-assets','web','','');
INSERT INTO permissions VALUES('291','delete-assets','web','','');
INSERT INTO permissions VALUES('292','daily-attendances','web','','');
INSERT INTO permissions VALUES('293','date-wise-attendances','web','','');
INSERT INTO permissions VALUES('294','monthly-attendances','web','','');
INSERT INTO permissions VALUES('295','set-permission','web','','');
INSERT INTO permissions VALUES('296','get-leave-notification','web','','');
INSERT INTO permissions VALUES('297','report-pension','web','','');



CREATE TABLE `policies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `added_by` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `policies_company_id_foreign` (`company_id`),
  KEY `policies_added_by_foreign` (`added_by`),
  CONSTRAINT `policies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO policies VALUES('2','No smoking','No smoking during the office hours.Smoke in the smoking zone if you really have to','1','ash','2020-07-27 15:26:24','2020-07-27 15:26:24');
INSERT INTO policies VALUES('3','No Social Media','You can not use any  social media.','1','admin','2023-02-01 13:00:21','2023-02-01 13:00:21');



CREATE TABLE `project_bugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `title` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bug_attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_bugs_user_id_foreign` (`user_id`),
  KEY `project_bugs_project_id_foreign` (`project_id`),
  CONSTRAINT `project_bugs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_bugs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_discussions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `project_discussion` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discussion_attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_discussions_user_id_foreign` (`user_id`),
  KEY `project_discussions_project_id_foreign` (`project_id`),
  CONSTRAINT `project_discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO project_discussions VALUES('1','1','1','Hola','','2020-07-28 20:42:38','2020-07-28 20:42:38');



CREATE TABLE `project_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `file_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_files_user_id_foreign` (`user_id`),
  KEY `project_files_project_id_foreign` (`project_id`),
  CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `projects` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `project_priority` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `summary` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not started',
  `project_note` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_progress` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_client_id_foreign` (`client_id`),
  KEY `projects_company_id_foreign` (`company_id`),
  KEY `projects_added_by_foreign` (`added_by`),
  CONSTRAINT `projects_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO projects VALUES('1','Test1','','1','2021-03-29','2021-04-02','medium','&lt;ul&gt;
&lt;li&gt;Section 2: Functional Objectives&lt;br /&gt;Each objective gives a desired behavior for the system, a business justification, and a measure to determine if the final system has successfully met the objective. These objectives are organized by priority. In order for the new system to be considered successful, all high priority objectives must be met.&lt;/li&gt;
&lt;li&gt;Section 3: Non-Functional Objectives&lt;br /&gt;This section is organized by category. Each objective specifies a technical requirement or constraint on the overall characteristics of the system. Each objective is measurable.&lt;/li&gt;
&lt;li&gt;Section 4: Context Model&lt;br /&gt;This section gives a text description of the goal of the system, and a pictorial description of the scope of the system in a context diagram. Those entities outside the system that interact with the system are described.&lt;/li&gt;
&lt;/ul&gt;','tinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will','in_progress','Note','36','','','2020-07-28 20:28:29','2020-11-02 08:17:03');
INSERT INTO projects VALUES('3','test3','','1','2021-03-31','2021-04-04','high','&lt;p&gt;&amp;nbsp;&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;&lt;strong&gt;A sales agent should be able to use the system in his job after x days of training.&lt;/strong&gt;&lt;/li&gt;
&lt;li&gt;&lt;strong&gt;A user who already knows what product he is interested in should be able to locate and view that page in x seconds.&lt;/strong&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;&amp;nbsp;&lt;/p&gt;','','not_started','','55','','','2020-08-03 14:56:42','2020-11-02 08:21:05');
INSERT INTO projects VALUES('4','Test','','1','2023-02-21','2023-02-22','medium','&lt;p&gt;Test&lt;/p&gt;','','not started','','','','','2023-02-09 10:32:21','2023-02-09 10:32:21');



CREATE TABLE `promotions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `promotion_title` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `promotion_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `promotions_company_id_foreign` (`company_id`),
  KEY `promotions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `promotions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `promotions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO promotions VALUES('1','Senior Executive 1','Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500s','1','9','2023-01-31','2020-07-27 15:34:35','2023-01-04 10:41:31');
INSERT INTO promotions VALUES('2','WEB','good job','11','59','2025-05-19','2025-05-17 15:12:39','2025-05-17 15:12:39');



CREATE TABLE `qualification_education_levels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_education_levels_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_education_levels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO qualification_education_levels VALUES('1','','BSC','2020-07-27 09:24:02','2020-07-27 09:24:02');
INSERT INTO qualification_education_levels VALUES('2','','Diploma','2020-07-27 09:24:06','2020-07-27 09:24:06');
INSERT INTO qualification_education_levels VALUES('3','','BBA','2020-07-27 09:24:14','2020-07-27 09:24:14');



CREATE TABLE `qualification_languages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_languages_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_languages_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO qualification_languages VALUES('1','','English','2020-10-20 09:02:36','2020-10-20 09:02:36');
INSERT INTO qualification_languages VALUES('2','','Hindi','2020-10-20 09:02:44','2025-05-16 14:02:30');



CREATE TABLE `qualification_skills` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_skills_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO qualification_skills VALUES('1','','MS Word','2020-10-20 09:02:54','2020-10-20 09:02:54');
INSERT INTO qualification_skills VALUES('2','','Photoshop','2020-10-20 09:03:02','2020-10-20 09:03:02');



CREATE TABLE `relation_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO relation_types VALUES('1','Self','2024-07-22 21:25:26','2024-07-22 22:11:26','');
INSERT INTO relation_types VALUES('2','Parent','2024-07-22 21:25:49','2024-07-22 22:17:43','');



CREATE TABLE `resignations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `notice_date` date DEFAULT NULL,
  `resignation_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resignations_company_id_foreign` (`company_id`),
  KEY `resignations_department_id_foreign` (`department_id`),
  KEY `resignations_employee_id_foreign` (`employee_id`),
  CONSTRAINT `resignations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES('1','5');
INSERT INTO role_has_permissions VALUES('2','5');
INSERT INTO role_has_permissions VALUES('3','5');
INSERT INTO role_has_permissions VALUES('4','5');
INSERT INTO role_has_permissions VALUES('5','5');
INSERT INTO role_has_permissions VALUES('6','5');
INSERT INTO role_has_permissions VALUES('7','5');
INSERT INTO role_has_permissions VALUES('8','5');
INSERT INTO role_has_permissions VALUES('9','5');
INSERT INTO role_has_permissions VALUES('10','5');
INSERT INTO role_has_permissions VALUES('11','5');
INSERT INTO role_has_permissions VALUES('13','5');
INSERT INTO role_has_permissions VALUES('14','5');
INSERT INTO role_has_permissions VALUES('15','5');
INSERT INTO role_has_permissions VALUES('16','5');
INSERT INTO role_has_permissions VALUES('17','5');
INSERT INTO role_has_permissions VALUES('18','5');
INSERT INTO role_has_permissions VALUES('20','5');
INSERT INTO role_has_permissions VALUES('21','5');
INSERT INTO role_has_permissions VALUES('22','5');
INSERT INTO role_has_permissions VALUES('23','5');
INSERT INTO role_has_permissions VALUES('24','5');
INSERT INTO role_has_permissions VALUES('25','5');
INSERT INTO role_has_permissions VALUES('26','5');
INSERT INTO role_has_permissions VALUES('27','5');
INSERT INTO role_has_permissions VALUES('28','5');
INSERT INTO role_has_permissions VALUES('29','5');
INSERT INTO role_has_permissions VALUES('30','5');
INSERT INTO role_has_permissions VALUES('31','5');
INSERT INTO role_has_permissions VALUES('32','5');
INSERT INTO role_has_permissions VALUES('33','5');
INSERT INTO role_has_permissions VALUES('34','5');
INSERT INTO role_has_permissions VALUES('35','5');
INSERT INTO role_has_permissions VALUES('36','5');
INSERT INTO role_has_permissions VALUES('37','5');
INSERT INTO role_has_permissions VALUES('38','5');
INSERT INTO role_has_permissions VALUES('39','5');
INSERT INTO role_has_permissions VALUES('41','5');
INSERT INTO role_has_permissions VALUES('42','5');
INSERT INTO role_has_permissions VALUES('43','5');
INSERT INTO role_has_permissions VALUES('44','5');
INSERT INTO role_has_permissions VALUES('46','5');
INSERT INTO role_has_permissions VALUES('47','5');
INSERT INTO role_has_permissions VALUES('48','5');
INSERT INTO role_has_permissions VALUES('49','5');
INSERT INTO role_has_permissions VALUES('50','5');
INSERT INTO role_has_permissions VALUES('51','5');
INSERT INTO role_has_permissions VALUES('52','5');
INSERT INTO role_has_permissions VALUES('53','5');
INSERT INTO role_has_permissions VALUES('54','5');
INSERT INTO role_has_permissions VALUES('55','5');
INSERT INTO role_has_permissions VALUES('56','5');
INSERT INTO role_has_permissions VALUES('57','5');
INSERT INTO role_has_permissions VALUES('58','5');
INSERT INTO role_has_permissions VALUES('59','5');
INSERT INTO role_has_permissions VALUES('60','5');
INSERT INTO role_has_permissions VALUES('61','5');
INSERT INTO role_has_permissions VALUES('62','5');
INSERT INTO role_has_permissions VALUES('63','5');
INSERT INTO role_has_permissions VALUES('64','5');
INSERT INTO role_has_permissions VALUES('65','5');
INSERT INTO role_has_permissions VALUES('66','5');
INSERT INTO role_has_permissions VALUES('67','5');
INSERT INTO role_has_permissions VALUES('68','5');
INSERT INTO role_has_permissions VALUES('69','5');
INSERT INTO role_has_permissions VALUES('70','5');
INSERT INTO role_has_permissions VALUES('71','5');
INSERT INTO role_has_permissions VALUES('72','5');
INSERT INTO role_has_permissions VALUES('73','5');
INSERT INTO role_has_permissions VALUES('74','5');
INSERT INTO role_has_permissions VALUES('75','5');
INSERT INTO role_has_permissions VALUES('76','5');
INSERT INTO role_has_permissions VALUES('81','5');
INSERT INTO role_has_permissions VALUES('82','5');
INSERT INTO role_has_permissions VALUES('83','5');
INSERT INTO role_has_permissions VALUES('84','5');
INSERT INTO role_has_permissions VALUES('85','5');
INSERT INTO role_has_permissions VALUES('86','5');
INSERT INTO role_has_permissions VALUES('87','5');
INSERT INTO role_has_permissions VALUES('90','5');
INSERT INTO role_has_permissions VALUES('91','5');
INSERT INTO role_has_permissions VALUES('92','5');
INSERT INTO role_has_permissions VALUES('93','5');
INSERT INTO role_has_permissions VALUES('94','5');
INSERT INTO role_has_permissions VALUES('95','5');
INSERT INTO role_has_permissions VALUES('96','5');
INSERT INTO role_has_permissions VALUES('97','5');
INSERT INTO role_has_permissions VALUES('98','5');
INSERT INTO role_has_permissions VALUES('104','5');
INSERT INTO role_has_permissions VALUES('105','5');
INSERT INTO role_has_permissions VALUES('106','5');
INSERT INTO role_has_permissions VALUES('107','5');
INSERT INTO role_has_permissions VALUES('108','5');
INSERT INTO role_has_permissions VALUES('109','5');
INSERT INTO role_has_permissions VALUES('110','5');
INSERT INTO role_has_permissions VALUES('112','5');
INSERT INTO role_has_permissions VALUES('113','5');
INSERT INTO role_has_permissions VALUES('114','5');
INSERT INTO role_has_permissions VALUES('115','5');
INSERT INTO role_has_permissions VALUES('116','5');
INSERT INTO role_has_permissions VALUES('117','5');
INSERT INTO role_has_permissions VALUES('118','5');
INSERT INTO role_has_permissions VALUES('119','5');
INSERT INTO role_has_permissions VALUES('120','5');
INSERT INTO role_has_permissions VALUES('121','5');
INSERT INTO role_has_permissions VALUES('122','5');
INSERT INTO role_has_permissions VALUES('123','5');
INSERT INTO role_has_permissions VALUES('124','5');
INSERT INTO role_has_permissions VALUES('125','5');
INSERT INTO role_has_permissions VALUES('126','5');
INSERT INTO role_has_permissions VALUES('127','5');
INSERT INTO role_has_permissions VALUES('128','5');
INSERT INTO role_has_permissions VALUES('129','5');
INSERT INTO role_has_permissions VALUES('130','5');
INSERT INTO role_has_permissions VALUES('131','5');
INSERT INTO role_has_permissions VALUES('132','5');
INSERT INTO role_has_permissions VALUES('133','5');
INSERT INTO role_has_permissions VALUES('134','5');
INSERT INTO role_has_permissions VALUES('135','5');
INSERT INTO role_has_permissions VALUES('136','5');
INSERT INTO role_has_permissions VALUES('137','5');
INSERT INTO role_has_permissions VALUES('138','5');
INSERT INTO role_has_permissions VALUES('139','5');
INSERT INTO role_has_permissions VALUES('140','5');
INSERT INTO role_has_permissions VALUES('141','5');
INSERT INTO role_has_permissions VALUES('142','5');
INSERT INTO role_has_permissions VALUES('144','5');
INSERT INTO role_has_permissions VALUES('145','5');
INSERT INTO role_has_permissions VALUES('146','5');
INSERT INTO role_has_permissions VALUES('147','5');
INSERT INTO role_has_permissions VALUES('148','5');
INSERT INTO role_has_permissions VALUES('149','5');
INSERT INTO role_has_permissions VALUES('150','5');
INSERT INTO role_has_permissions VALUES('151','5');
INSERT INTO role_has_permissions VALUES('152','5');
INSERT INTO role_has_permissions VALUES('153','5');
INSERT INTO role_has_permissions VALUES('154','5');
INSERT INTO role_has_permissions VALUES('156','5');
INSERT INTO role_has_permissions VALUES('157','5');
INSERT INTO role_has_permissions VALUES('158','5');
INSERT INTO role_has_permissions VALUES('159','5');
INSERT INTO role_has_permissions VALUES('160','5');
INSERT INTO role_has_permissions VALUES('161','5');
INSERT INTO role_has_permissions VALUES('162','5');
INSERT INTO role_has_permissions VALUES('163','5');
INSERT INTO role_has_permissions VALUES('164','5');
INSERT INTO role_has_permissions VALUES('165','5');
INSERT INTO role_has_permissions VALUES('166','5');
INSERT INTO role_has_permissions VALUES('167','5');
INSERT INTO role_has_permissions VALUES('168','5');
INSERT INTO role_has_permissions VALUES('169','5');
INSERT INTO role_has_permissions VALUES('170','5');
INSERT INTO role_has_permissions VALUES('171','5');
INSERT INTO role_has_permissions VALUES('172','5');
INSERT INTO role_has_permissions VALUES('173','5');
INSERT INTO role_has_permissions VALUES('176','5');
INSERT INTO role_has_permissions VALUES('177','5');
INSERT INTO role_has_permissions VALUES('178','5');
INSERT INTO role_has_permissions VALUES('179','5');
INSERT INTO role_has_permissions VALUES('180','5');
INSERT INTO role_has_permissions VALUES('181','5');
INSERT INTO role_has_permissions VALUES('182','5');
INSERT INTO role_has_permissions VALUES('183','5');
INSERT INTO role_has_permissions VALUES('184','5');
INSERT INTO role_has_permissions VALUES('185','5');
INSERT INTO role_has_permissions VALUES('186','5');
INSERT INTO role_has_permissions VALUES('187','5');
INSERT INTO role_has_permissions VALUES('188','5');
INSERT INTO role_has_permissions VALUES('189','5');
INSERT INTO role_has_permissions VALUES('190','5');
INSERT INTO role_has_permissions VALUES('191','5');
INSERT INTO role_has_permissions VALUES('192','5');
INSERT INTO role_has_permissions VALUES('193','5');
INSERT INTO role_has_permissions VALUES('194','5');
INSERT INTO role_has_permissions VALUES('195','5');
INSERT INTO role_has_permissions VALUES('196','5');
INSERT INTO role_has_permissions VALUES('197','5');
INSERT INTO role_has_permissions VALUES('198','5');
INSERT INTO role_has_permissions VALUES('199','5');
INSERT INTO role_has_permissions VALUES('200','5');
INSERT INTO role_has_permissions VALUES('201','5');
INSERT INTO role_has_permissions VALUES('202','5');
INSERT INTO role_has_permissions VALUES('203','5');
INSERT INTO role_has_permissions VALUES('204','5');
INSERT INTO role_has_permissions VALUES('205','5');
INSERT INTO role_has_permissions VALUES('206','5');
INSERT INTO role_has_permissions VALUES('207','5');
INSERT INTO role_has_permissions VALUES('208','5');
INSERT INTO role_has_permissions VALUES('209','5');
INSERT INTO role_has_permissions VALUES('210','5');
INSERT INTO role_has_permissions VALUES('211','5');
INSERT INTO role_has_permissions VALUES('212','5');
INSERT INTO role_has_permissions VALUES('213','5');
INSERT INTO role_has_permissions VALUES('214','5');
INSERT INTO role_has_permissions VALUES('215','5');
INSERT INTO role_has_permissions VALUES('216','5');
INSERT INTO role_has_permissions VALUES('217','5');
INSERT INTO role_has_permissions VALUES('218','5');
INSERT INTO role_has_permissions VALUES('220','5');
INSERT INTO role_has_permissions VALUES('221','5');
INSERT INTO role_has_permissions VALUES('222','5');
INSERT INTO role_has_permissions VALUES('223','5');
INSERT INTO role_has_permissions VALUES('224','5');
INSERT INTO role_has_permissions VALUES('225','5');
INSERT INTO role_has_permissions VALUES('226','5');
INSERT INTO role_has_permissions VALUES('227','5');
INSERT INTO role_has_permissions VALUES('228','5');
INSERT INTO role_has_permissions VALUES('229','5');
INSERT INTO role_has_permissions VALUES('230','5');
INSERT INTO role_has_permissions VALUES('231','5');
INSERT INTO role_has_permissions VALUES('232','5');
INSERT INTO role_has_permissions VALUES('233','5');
INSERT INTO role_has_permissions VALUES('234','5');
INSERT INTO role_has_permissions VALUES('235','5');
INSERT INTO role_has_permissions VALUES('236','5');
INSERT INTO role_has_permissions VALUES('237','5');
INSERT INTO role_has_permissions VALUES('238','5');
INSERT INTO role_has_permissions VALUES('239','5');
INSERT INTO role_has_permissions VALUES('240','5');
INSERT INTO role_has_permissions VALUES('241','5');
INSERT INTO role_has_permissions VALUES('242','5');
INSERT INTO role_has_permissions VALUES('243','5');
INSERT INTO role_has_permissions VALUES('244','5');
INSERT INTO role_has_permissions VALUES('245','5');
INSERT INTO role_has_permissions VALUES('246','5');
INSERT INTO role_has_permissions VALUES('247','5');
INSERT INTO role_has_permissions VALUES('248','5');
INSERT INTO role_has_permissions VALUES('249','5');
INSERT INTO role_has_permissions VALUES('250','5');
INSERT INTO role_has_permissions VALUES('251','5');
INSERT INTO role_has_permissions VALUES('252','5');
INSERT INTO role_has_permissions VALUES('253','5');
INSERT INTO role_has_permissions VALUES('254','5');
INSERT INTO role_has_permissions VALUES('255','5');
INSERT INTO role_has_permissions VALUES('256','5');
INSERT INTO role_has_permissions VALUES('257','5');
INSERT INTO role_has_permissions VALUES('258','5');
INSERT INTO role_has_permissions VALUES('259','5');
INSERT INTO role_has_permissions VALUES('260','5');
INSERT INTO role_has_permissions VALUES('261','5');
INSERT INTO role_has_permissions VALUES('262','5');
INSERT INTO role_has_permissions VALUES('263','5');
INSERT INTO role_has_permissions VALUES('264','5');
INSERT INTO role_has_permissions VALUES('265','5');
INSERT INTO role_has_permissions VALUES('266','5');
INSERT INTO role_has_permissions VALUES('267','5');
INSERT INTO role_has_permissions VALUES('268','5');
INSERT INTO role_has_permissions VALUES('269','5');
INSERT INTO role_has_permissions VALUES('270','5');
INSERT INTO role_has_permissions VALUES('271','5');
INSERT INTO role_has_permissions VALUES('272','5');
INSERT INTO role_has_permissions VALUES('273','5');
INSERT INTO role_has_permissions VALUES('274','5');
INSERT INTO role_has_permissions VALUES('275','5');
INSERT INTO role_has_permissions VALUES('276','5');
INSERT INTO role_has_permissions VALUES('277','5');
INSERT INTO role_has_permissions VALUES('278','5');
INSERT INTO role_has_permissions VALUES('279','5');
INSERT INTO role_has_permissions VALUES('280','5');
INSERT INTO role_has_permissions VALUES('281','5');
INSERT INTO role_has_permissions VALUES('282','5');
INSERT INTO role_has_permissions VALUES('283','5');
INSERT INTO role_has_permissions VALUES('284','5');
INSERT INTO role_has_permissions VALUES('285','5');
INSERT INTO role_has_permissions VALUES('286','5');
INSERT INTO role_has_permissions VALUES('287','5');
INSERT INTO role_has_permissions VALUES('288','5');
INSERT INTO role_has_permissions VALUES('289','5');
INSERT INTO role_has_permissions VALUES('290','5');
INSERT INTO role_has_permissions VALUES('291','5');
INSERT INTO role_has_permissions VALUES('292','5');
INSERT INTO role_has_permissions VALUES('293','5');
INSERT INTO role_has_permissions VALUES('294','5');
INSERT INTO role_has_permissions VALUES('295','5');
INSERT INTO role_has_permissions VALUES('296','5');
INSERT INTO role_has_permissions VALUES('297','5');
INSERT INTO role_has_permissions VALUES('1','6');
INSERT INTO role_has_permissions VALUES('2','6');
INSERT INTO role_has_permissions VALUES('3','6');
INSERT INTO role_has_permissions VALUES('4','6');
INSERT INTO role_has_permissions VALUES('5','6');
INSERT INTO role_has_permissions VALUES('6','6');
INSERT INTO role_has_permissions VALUES('7','6');
INSERT INTO role_has_permissions VALUES('8','6');
INSERT INTO role_has_permissions VALUES('9','6');
INSERT INTO role_has_permissions VALUES('10','6');
INSERT INTO role_has_permissions VALUES('20','6');
INSERT INTO role_has_permissions VALUES('21','6');
INSERT INTO role_has_permissions VALUES('22','6');
INSERT INTO role_has_permissions VALUES('23','6');
INSERT INTO role_has_permissions VALUES('24','6');
INSERT INTO role_has_permissions VALUES('25','6');
INSERT INTO role_has_permissions VALUES('26','6');
INSERT INTO role_has_permissions VALUES('27','6');
INSERT INTO role_has_permissions VALUES('28','6');
INSERT INTO role_has_permissions VALUES('29','6');
INSERT INTO role_has_permissions VALUES('30','6');
INSERT INTO role_has_permissions VALUES('31','6');
INSERT INTO role_has_permissions VALUES('32','6');
INSERT INTO role_has_permissions VALUES('33','6');
INSERT INTO role_has_permissions VALUES('34','6');
INSERT INTO role_has_permissions VALUES('35','6');
INSERT INTO role_has_permissions VALUES('36','6');
INSERT INTO role_has_permissions VALUES('37','6');
INSERT INTO role_has_permissions VALUES('38','6');
INSERT INTO role_has_permissions VALUES('39','6');
INSERT INTO role_has_permissions VALUES('41','6');
INSERT INTO role_has_permissions VALUES('42','6');
INSERT INTO role_has_permissions VALUES('43','6');
INSERT INTO role_has_permissions VALUES('44','6');
INSERT INTO role_has_permissions VALUES('46','6');
INSERT INTO role_has_permissions VALUES('52','6');
INSERT INTO role_has_permissions VALUES('53','6');
INSERT INTO role_has_permissions VALUES('54','6');
INSERT INTO role_has_permissions VALUES('55','6');
INSERT INTO role_has_permissions VALUES('56','6');
INSERT INTO role_has_permissions VALUES('57','6');
INSERT INTO role_has_permissions VALUES('58','6');
INSERT INTO role_has_permissions VALUES('59','6');
INSERT INTO role_has_permissions VALUES('60','6');
INSERT INTO role_has_permissions VALUES('61','6');
INSERT INTO role_has_permissions VALUES('62','6');
INSERT INTO role_has_permissions VALUES('63','6');
INSERT INTO role_has_permissions VALUES('64','6');
INSERT INTO role_has_permissions VALUES('65','6');
INSERT INTO role_has_permissions VALUES('66','6');
INSERT INTO role_has_permissions VALUES('67','6');
INSERT INTO role_has_permissions VALUES('68','6');
INSERT INTO role_has_permissions VALUES('69','6');
INSERT INTO role_has_permissions VALUES('70','6');
INSERT INTO role_has_permissions VALUES('71','6');
INSERT INTO role_has_permissions VALUES('72','6');
INSERT INTO role_has_permissions VALUES('73','6');
INSERT INTO role_has_permissions VALUES('74','6');
INSERT INTO role_has_permissions VALUES('75','6');
INSERT INTO role_has_permissions VALUES('76','6');
INSERT INTO role_has_permissions VALUES('81','6');
INSERT INTO role_has_permissions VALUES('82','6');
INSERT INTO role_has_permissions VALUES('83','6');
INSERT INTO role_has_permissions VALUES('84','6');
INSERT INTO role_has_permissions VALUES('85','6');
INSERT INTO role_has_permissions VALUES('86','6');
INSERT INTO role_has_permissions VALUES('87','6');
INSERT INTO role_has_permissions VALUES('90','6');
INSERT INTO role_has_permissions VALUES('91','6');
INSERT INTO role_has_permissions VALUES('92','6');
INSERT INTO role_has_permissions VALUES('93','6');
INSERT INTO role_has_permissions VALUES('94','6');
INSERT INTO role_has_permissions VALUES('95','6');
INSERT INTO role_has_permissions VALUES('96','6');
INSERT INTO role_has_permissions VALUES('97','6');
INSERT INTO role_has_permissions VALUES('98','6');
INSERT INTO role_has_permissions VALUES('104','6');
INSERT INTO role_has_permissions VALUES('105','6');
INSERT INTO role_has_permissions VALUES('106','6');
INSERT INTO role_has_permissions VALUES('107','6');
INSERT INTO role_has_permissions VALUES('108','6');
INSERT INTO role_has_permissions VALUES('109','6');
INSERT INTO role_has_permissions VALUES('110','6');
INSERT INTO role_has_permissions VALUES('112','6');
INSERT INTO role_has_permissions VALUES('113','6');
INSERT INTO role_has_permissions VALUES('114','6');
INSERT INTO role_has_permissions VALUES('115','6');
INSERT INTO role_has_permissions VALUES('116','6');
INSERT INTO role_has_permissions VALUES('144','6');
INSERT INTO role_has_permissions VALUES('145','6');
INSERT INTO role_has_permissions VALUES('146','6');
INSERT INTO role_has_permissions VALUES('153','6');
INSERT INTO role_has_permissions VALUES('158','6');
INSERT INTO role_has_permissions VALUES('159','6');
INSERT INTO role_has_permissions VALUES('160','6');
INSERT INTO role_has_permissions VALUES('161','6');
INSERT INTO role_has_permissions VALUES('162','6');
INSERT INTO role_has_permissions VALUES('163','6');
INSERT INTO role_has_permissions VALUES('164','6');
INSERT INTO role_has_permissions VALUES('165','6');
INSERT INTO role_has_permissions VALUES('166','6');
INSERT INTO role_has_permissions VALUES('167','6');
INSERT INTO role_has_permissions VALUES('168','6');
INSERT INTO role_has_permissions VALUES('208','6');
INSERT INTO role_has_permissions VALUES('209','6');
INSERT INTO role_has_permissions VALUES('210','6');
INSERT INTO role_has_permissions VALUES('214','6');
INSERT INTO role_has_permissions VALUES('215','6');
INSERT INTO role_has_permissions VALUES('216','6');
INSERT INTO role_has_permissions VALUES('217','6');
INSERT INTO role_has_permissions VALUES('218','6');
INSERT INTO role_has_permissions VALUES('223','6');
INSERT INTO role_has_permissions VALUES('224','6');
INSERT INTO role_has_permissions VALUES('225','6');
INSERT INTO role_has_permissions VALUES('226','6');
INSERT INTO role_has_permissions VALUES('232','6');
INSERT INTO role_has_permissions VALUES('233','6');
INSERT INTO role_has_permissions VALUES('234','6');
INSERT INTO role_has_permissions VALUES('235','6');
INSERT INTO role_has_permissions VALUES('236','6');
INSERT INTO role_has_permissions VALUES('237','6');
INSERT INTO role_has_permissions VALUES('238','6');
INSERT INTO role_has_permissions VALUES('239','6');
INSERT INTO role_has_permissions VALUES('240','6');
INSERT INTO role_has_permissions VALUES('241','6');
INSERT INTO role_has_permissions VALUES('242','6');
INSERT INTO role_has_permissions VALUES('243','6');
INSERT INTO role_has_permissions VALUES('244','6');
INSERT INTO role_has_permissions VALUES('245','6');
INSERT INTO role_has_permissions VALUES('246','6');
INSERT INTO role_has_permissions VALUES('247','6');
INSERT INTO role_has_permissions VALUES('248','6');
INSERT INTO role_has_permissions VALUES('249','6');
INSERT INTO role_has_permissions VALUES('250','6');
INSERT INTO role_has_permissions VALUES('251','6');
INSERT INTO role_has_permissions VALUES('252','6');
INSERT INTO role_has_permissions VALUES('253','6');
INSERT INTO role_has_permissions VALUES('254','6');
INSERT INTO role_has_permissions VALUES('255','6');
INSERT INTO role_has_permissions VALUES('256','6');
INSERT INTO role_has_permissions VALUES('257','6');
INSERT INTO role_has_permissions VALUES('258','6');
INSERT INTO role_has_permissions VALUES('259','6');
INSERT INTO role_has_permissions VALUES('260','6');
INSERT INTO role_has_permissions VALUES('261','6');
INSERT INTO role_has_permissions VALUES('262','6');
INSERT INTO role_has_permissions VALUES('263','6');
INSERT INTO role_has_permissions VALUES('264','6');
INSERT INTO role_has_permissions VALUES('265','6');
INSERT INTO role_has_permissions VALUES('266','6');
INSERT INTO role_has_permissions VALUES('267','6');
INSERT INTO role_has_permissions VALUES('268','6');
INSERT INTO role_has_permissions VALUES('269','6');
INSERT INTO role_has_permissions VALUES('270','6');
INSERT INTO role_has_permissions VALUES('271','6');
INSERT INTO role_has_permissions VALUES('272','6');
INSERT INTO role_has_permissions VALUES('273','6');
INSERT INTO role_has_permissions VALUES('274','6');
INSERT INTO role_has_permissions VALUES('275','6');
INSERT INTO role_has_permissions VALUES('276','6');
INSERT INTO role_has_permissions VALUES('277','6');
INSERT INTO role_has_permissions VALUES('278','6');
INSERT INTO role_has_permissions VALUES('279','6');
INSERT INTO role_has_permissions VALUES('280','6');
INSERT INTO role_has_permissions VALUES('281','6');
INSERT INTO role_has_permissions VALUES('282','6');
INSERT INTO role_has_permissions VALUES('283','6');
INSERT INTO role_has_permissions VALUES('287','6');
INSERT INTO role_has_permissions VALUES('288','6');
INSERT INTO role_has_permissions VALUES('292','6');
INSERT INTO role_has_permissions VALUES('293','6');
INSERT INTO role_has_permissions VALUES('294','6');
INSERT INTO role_has_permissions VALUES('296','6');
INSERT INTO role_has_permissions VALUES('297','6');



CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1','admin','web','Can access and change everything','1','','');
INSERT INTO roles VALUES('2','employee','web','Default access','1','2020-07-26 19:20:45','2020-07-26 19:20:45');
INSERT INTO roles VALUES('3','client','web','When you create a client, this role and associated.','1','2020-10-08 08:40:23','2020-10-08 08:40:23');
INSERT INTO roles VALUES('4','Manager','web','Can Manage','1','2021-02-24 15:54:58','2021-02-24 15:54:58');
INSERT INTO roles VALUES('5','Editor','web','Custom access','1','2021-02-24 15:54:58','2021-02-24 15:54:58');
INSERT INTO roles VALUES('6','HR','web','','1','2021-09-05 08:42:28','2021-09-05 08:42:28');



CREATE TABLE `salary_allowances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `allowance_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `allowance_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_taxable` tinyint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_allowances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_allowances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_allowances VALUES('1','11','January-2021','2021-01-01','Home','200','0','2020-07-29 21:40:53','2020-07-29 21:40:53');
INSERT INTO salary_allowances VALUES('2','11','January-2021','2021-01-01','Tea','50','0','2020-07-29 23:38:42','2020-07-29 23:38:42');
INSERT INTO salary_allowances VALUES('5','9','January-2021','2021-01-01','xyz','75','1','2021-01-26 00:31:56','2021-04-09 07:07:55');
INSERT INTO salary_allowances VALUES('13','9','April-2021','2021-04-01','Tea','50','0','2021-04-09 06:05:35','2021-04-09 07:17:08');
INSERT INTO salary_allowances VALUES('14','9','April-2021','2021-04-01','Coffee','50','0','2021-04-09 07:09:02','2021-04-09 07:17:22');
INSERT INTO salary_allowances VALUES('15','9','August-2021','2021-08-01','Milk','200','0','2021-04-09 11:08:21','2021-04-09 11:08:21');
INSERT INTO salary_allowances VALUES('16','11','October-2022','2022-10-01','Transportation','10','0','2022-10-18 20:47:19','2022-10-18 20:47:19');
INSERT INTO salary_allowances VALUES('17','11','October-2022','2022-10-01','Communication','10','0','2022-10-18 20:47:44','2022-10-18 20:47:44');
INSERT INTO salary_allowances VALUES('18','59','May-2025','2025-05-01','HRA','29272','1','2025-05-22 15:19:00','2025-05-22 15:19:00');
INSERT INTO salary_allowances VALUES('19','59','May-2025','2025-05-01','CCA','9757','1','2025-05-22 15:21:34','2025-05-22 15:21:34');
INSERT INTO salary_allowances VALUES('20','59','May-2025','2025-05-01','PF','1800','0','2025-05-22 15:24:47','2025-05-22 15:24:47');



CREATE TABLE `salary_basics` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `payslip_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `basic_salary` double NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_basics_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_basics_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_basics VALUES('1','9','January-2021','2021-01-01','Monthly','500','','2022-02-27 12:14:40');
INSERT INTO salary_basics VALUES('2','9','April-2021','2021-04-01','Monthly','700','','2022-02-27 12:15:00');
INSERT INTO salary_basics VALUES('3','9','February-2021','2021-02-01','Monthly','10','2021-04-06 06:59:14','2022-02-27 12:14:50');
INSERT INTO salary_basics VALUES('10','11','January-2021','2021-01-01','Hourly','100','2021-04-08 20:44:20','2021-04-08 20:44:20');
INSERT INTO salary_basics VALUES('23','9','July-2021','2021-07-01','Monthly','500','2021-07-17 06:46:42','2022-02-27 12:15:12');
INSERT INTO salary_basics VALUES('25','11','October-2022','2022-10-01','Monthly','100','2022-10-18 20:45:31','2022-10-18 20:45:31');
INSERT INTO salary_basics VALUES('27','9','January-2024','2024-01-01','Monthly','100','2024-01-15 11:39:50','2024-01-15 11:39:50');
INSERT INTO salary_basics VALUES('29','59','May-2025','2025-05-01','Monthly','58544','2025-05-16 14:04:39','2025-05-22 15:22:24');



CREATE TABLE `salary_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `commission_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `commission_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_commissions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_commissions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_commissions VALUES('1','11','January-2021','Sale','2021-01-01','20','2020-07-29 23:43:30','2020-07-29 23:43:30');
INSERT INTO salary_commissions VALUES('20','9','January-2021','Sale','2021-01-01','100','2021-04-09 21:06:18','2021-04-09 21:14:58');
INSERT INTO salary_commissions VALUES('21','9','April-2021','Performance','2021-04-01','200','2021-04-09 21:12:48','2021-04-09 21:12:48');
INSERT INTO salary_commissions VALUES('22','9','April-2021','XYZ','2021-04-01','50','2021-04-09 21:31:54','2021-04-09 21:31:54');



CREATE TABLE `salary_deductions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `deduction_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deduction_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deduction_type_id` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_deductions_employee_id_foreign` (`employee_id`),
  KEY `salary_deductions_deduction_type_id_foreign` (`deduction_type_id`),
  CONSTRAINT `salary_deductions_deduction_type_id_foreign` FOREIGN KEY (`deduction_type_id`) REFERENCES `deduction_types` (`id`),
  CONSTRAINT `salary_deductions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_deductions VALUES('1','11','January-2021','2021-01-01','Test','10','1','2020-07-29 23:51:22','2020-07-29 23:51:22');
INSERT INTO salary_deductions VALUES('8','9','January-2021','2021-01-01','Tax','20','1','2021-04-10 18:25:34','2021-04-10 18:25:34');
INSERT INTO salary_deductions VALUES('10','9','April-2021','2021-04-01','Fever','100','1','2021-04-10 18:46:30','2021-04-10 18:46:30');
INSERT INTO salary_deductions VALUES('11','11','October-2022','2022-10-01','Medical','15','1','2022-10-18 20:49:18','2022-10-18 20:49:18');
INSERT INTO salary_deductions VALUES('15','59','May-2025','2025-05-01','PF','1800','8','2025-05-22 14:26:07','2025-05-22 15:25:27');



CREATE TABLE `salary_loans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `loan_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `loan_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `loan_type_id` bigint unsigned NOT NULL DEFAULT '1',
  `loan_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount_remaining` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_remaining` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `monthly_payable` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reason` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_loans_employee_id_foreign` (`employee_id`),
  KEY `salary_loans_loan_type_id_foreign` (`loan_type_id`),
  CONSTRAINT `salary_loans_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `salary_loans_loan_type_id_foreign` FOREIGN KEY (`loan_type_id`) REFERENCES `loan_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_loans VALUES('8','11','March-2021','2021-03-01','','100','1','4','0','0','0','Make House','2021-04-11 18:13:20','2023-04-15 13:28:00');
INSERT INTO salary_loans VALUES('9','11','October-2022','2022-10-01','','50','1','1','0','0','0','','2022-10-18 20:48:13','2023-04-15 13:28:00');
INSERT INTO salary_loans VALUES('15','9','July-2024','2024-07-01','test','20','3','4','20','4','5.000','test','2024-07-23 10:49:49','2024-07-23 10:55:04');
INSERT INTO salary_loans VALUES('16','59','February-2025','2025-02-01','Home Loan','70000','1','14','70000','14','5,000.000','Approved by Mr.Varun','2025-05-22 15:35:04','2025-05-22 15:35:04');



CREATE TABLE `salary_other_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_date` date DEFAULT NULL,
  `other_payment_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `other_payment_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_other_payments_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_other_payments_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_other_payments VALUES('2','9','January-2021','2021-01-01','Clean','150','2021-04-10 20:35:16','2021-04-10 20:35:16');
INSERT INTO salary_other_payments VALUES('3','9','April-2021','2021-04-01','abc','50','2021-04-10 20:36:18','2021-04-10 20:36:18');
INSERT INTO salary_other_payments VALUES('4','9','April-2021','2021-04-01','xyz','50','2021-04-10 20:52:47','2021-04-10 20:52:47');
INSERT INTO salary_other_payments VALUES('5','11','October-2022','2022-10-01','Reimbursement','11','2022-10-18 20:49:39','2022-10-18 20:49:39');



CREATE TABLE `salary_overtimes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `month_year` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date DEFAULT NULL,
  `overtime_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `no_of_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime_hours` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime_rate` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_overtimes_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_overtimes_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_overtimes VALUES('1','11','','','Test Overtime','2','20','20','400','2020-07-29 23:53:33','2020-07-29 23:53:33');
INSERT INTO salary_overtimes VALUES('2','11','','','test overtime 2','3','10','3','30','2020-07-29 23:54:20','2020-07-29 23:54:20');
INSERT INTO salary_overtimes VALUES('11','9','January-2021','2021-01-01','Project-1','2','10','5','50','2021-04-10 22:17:20','2021-04-10 22:17:37');
INSERT INTO salary_overtimes VALUES('12','9','April-2021','2021-04-01','Project-2','5','10','3','30','2021-04-10 22:22:35','2021-04-10 22:38:14');
INSERT INTO salary_overtimes VALUES('13','9','April-2021','2021-04-01','Project-3','3','5','2','10','2021-04-10 22:23:13','2021-04-10 22:23:13');
INSERT INTO salary_overtimes VALUES('14','11','October-2022','2022-10-01','OT','4','8','0.5','4','2022-10-18 20:50:06','2022-10-18 20:50:06');



CREATE TABLE `statuses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO statuses VALUES('1','full-time','2020-07-27 01:54:16','2020-07-27 01:54:16');
INSERT INTO statuses VALUES('2','part-time','2020-07-27 01:54:26','2020-07-27 01:54:26');
INSERT INTO statuses VALUES('3','internship','2020-07-27 01:54:42','2020-07-27 01:54:42');
INSERT INTO statuses VALUES('4','terminated','2020-07-27 01:54:49','2020-07-27 01:54:49');



CREATE TABLE `support_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned DEFAULT NULL,
  `department_id` bigint unsigned DEFAULT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `ticket_code` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket_priority` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ticket_remarks` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ticket_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket_note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `ticket_attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `support_tickets_ticket_code_unique` (`ticket_code`),
  KEY `support_tickets_company_id_foreign` (`company_id`),
  KEY `support_tickets_department_id_foreign` (`department_id`),
  KEY `support_tickets_employee_id_foreign` (`employee_id`),
  CONSTRAINT `support_tickets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `support_tickets_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `support_tickets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO support_tickets VALUES('2','1','1','9','BYrKY0X8','Screen Issue','medium','&lt;p&gt;lorem ipsum&lt;strong&gt; lorem&lt;/strong&gt;&lt;/p&gt;','','pending','fix this issue ASAP','','ticket_BYrKY0X8.pdf','2020-08-03 11:47:26','2020-08-03 11:47:26');
INSERT INTO support_tickets VALUES('3','1','1','9','w406NhQv','Sed aliquam sit por','medium','wetwetwetwet','','pending','tetwetw','','','2023-01-01 12:45:36','2023-01-01 12:45:36');
INSERT INTO support_tickets VALUES('4','11','7','59','UCMgoQul','NA','medium','','','pending','hkvuhv','','','2025-05-17 13:29:40','2025-05-17 13:29:40');
INSERT INTO support_tickets VALUES('5','11','7','59','JmQnjkLA','internet issue','low','urgent','','open','please help','','','2025-05-17 13:35:24','2025-05-17 13:35:24');



CREATE TABLE `task_discussions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `task_discussion` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_discussions_user_id_foreign` (`user_id`),
  KEY `task_discussions_task_id_foreign` (`task_id`),
  CONSTRAINT `task_discussions_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `task_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `file_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_files_user_id_foreign` (`user_id`),
  KEY `task_files_task_id_foreign` (`task_id`),
  CONSTRAINT `task_files_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO task_files VALUES('2','7','','Task by Sahiba','task_file_1672559303.png','Test','2023-01-01 13:18:23','2023-01-01 13:18:23');



CREATE TABLE `tasks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `project_id` bigint unsigned NOT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `task_hour` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `task_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not started',
  `task_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `task_progress` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_notify` tinyint DEFAULT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_project_id_foreign` (`project_id`),
  KEY `tasks_company_id_foreign` (`company_id`),
  KEY `tasks_added_by_foreign` (`added_by`),
  CONSTRAINT `tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO tasks VALUES('1','Test1 Task','1','1','2021-03-29','2021-04-01','20','&lt;table style=&quot;border-collapse: collapse; width: 100%; height: 45px;&quot; border=&quot;1&quot;&gt;
&lt;tbody&gt;
&lt;tr style=&quot;height: 15px;&quot;&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;gsba&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;svnba&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;/tr&gt;
&lt;tr style=&quot;height: 15px;&quot;&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;dfsd&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;dfsf&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;/tr&gt;
&lt;tr style=&quot;height: 15px;&quot;&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;td style=&quot;width: 20%; height: 15px;&quot;&gt;&amp;nbsp;&lt;/td&gt;
&lt;/tr&gt;
&lt;/tbody&gt;
&lt;/table&gt;','','','9','','1','2020-07-28 20:44:01','2020-11-02 07:12:14');
INSERT INTO tasks VALUES('3','aa','1','1','2021-03-31','2021-04-02','16','&lt;p&gt;new&lt;/p&gt;','not started','','','','','2020-10-11 22:42:09','2020-11-02 07:19:48');
INSERT INTO tasks VALUES('7','Mission 95','1','1','2023-01-01','2023-01-07','56','&lt;p&gt;Test&lt;/p&gt;','not started','','','','1','2023-01-01 12:51:58','2023-01-01 12:51:58');
INSERT INTO tasks VALUES('8','Task Title','1','1','2023-02-21','2023-02-22','50','&lt;p&gt;Test&lt;/p&gt;','not started','','','','1','2023-02-09 10:35:12','2023-02-09 10:35:12');



CREATE TABLE `tax_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO tax_types VALUES('1','No tax','0','fixed','zero tax','2020-07-28 22:01:42','2020-07-28 22:01:42');
INSERT INTO tax_types VALUES('2','Vat','5','percentage','5% vat for all item','2020-07-28 22:02:12','2020-07-28 22:02:12');



CREATE TABLE `termination_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `termination_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO termination_types VALUES('1','voluntery termination','2020-07-27 01:52:03','2020-07-27 01:52:03');
INSERT INTO termination_types VALUES('2','Performance Termination','2020-07-27 01:52:27','2020-07-27 01:52:27');



CREATE TABLE `terminations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned NOT NULL,
  `terminated_employee` bigint unsigned NOT NULL,
  `termination_type` bigint unsigned DEFAULT NULL,
  `termination_date` date NOT NULL,
  `notice_date` date NOT NULL,
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `terminations_company_id_foreign` (`company_id`),
  KEY `terminations_terminated_employee_foreign` (`terminated_employee`),
  KEY `terminations_termination_type_foreign` (`termination_type`),
  CONSTRAINT `terminations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_terminated_employee_foreign` FOREIGN KEY (`terminated_employee`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_termination_type_foreign` FOREIGN KEY (`termination_type`) REFERENCES `termination_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ticket_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ticket_comments` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_comments_ticket_id_foreign` (`ticket_id`),
  KEY `ticket_comments_user_id_foreign` (`user_id`),
  CONSTRAINT `ticket_comments_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ticket_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `trainers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `expertise` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `trainers_company_id_foreign` (`company_id`),
  CONSTRAINT `trainers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO trainers VALUES('1','Pink','Floyd','floyd@pink.com','76352839','1','Backstreet 22,Austria','Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est','','2020-07-28 00:44:54','2020-07-28 00:44:54');



CREATE TABLE `training_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `training_cost` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `trainer_id` bigint unsigned DEFAULT NULL,
  `training_type_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `training_lists_company_id_foreign` (`company_id`),
  KEY `training_lists_trainer_id_foreign` (`trainer_id`),
  KEY `training_lists_training_type_id_foreign` (`training_type_id`),
  CONSTRAINT `training_lists_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_trainer_id_foreign` FOREIGN KEY (`trainer_id`) REFERENCES `trainers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_training_type_id_foreign` FOREIGN KEY (`training_type_id`) REFERENCES `training_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO training_lists VALUES('1','Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est','2021-04-01','2021-04-02','200','','','1','1','1','2020-07-28 00:47:38','2020-07-28 00:47:38');
INSERT INTO training_lists VALUES('2','','2023-02-21','2023-02-22','5000','','','1','1','1','2023-02-09 10:13:34','2023-02-09 10:13:34');



CREATE TABLE `training_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO training_types VALUES('1','Job Training','','2020-07-28 00:40:52','2020-07-28 00:40:52');
INSERT INTO training_types VALUES('2','Workshop','','2020-07-28 00:40:59','2020-07-28 00:40:59');
INSERT INTO training_types VALUES('3','Mind Training','','2020-07-28 00:41:07','2020-07-28 00:41:07');
INSERT INTO training_types VALUES('10','test','','2023-08-02 11:05:23','2023-08-02 11:05:23');
INSERT INTO training_types VALUES('11','test123','','2023-08-02 11:06:42','2023-08-02 11:06:42');
INSERT INTO training_types VALUES('14','test55','','2023-11-07 15:31:52','2023-11-07 15:31:52');



CREATE TABLE `transfers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned DEFAULT NULL,
  `from_department_id` bigint unsigned DEFAULT NULL,
  `to_department_id` bigint unsigned DEFAULT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `transfer_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfers_company_id_foreign` (`company_id`),
  KEY `transfers_from_department_id_foreign` (`from_department_id`),
  KEY `transfers_to_department_id_foreign` (`to_department_id`),
  KEY `transfers_employee_id_foreign` (`employee_id`),
  CONSTRAINT `transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_from_department_id_foreign` FOREIGN KEY (`from_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_to_department_id_foreign` FOREIGN KEY (`to_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `translations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int unsigned NOT NULL,
  `group` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `translations_language_id_foreign` (`language_id`),
  CONSTRAINT `translations_language_id_foreign` FOREIGN KEY (`language_id`) REFERENCES `languages` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `travel_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `arrangement_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travel_types_company_id_foreign` (`company_id`),
  CONSTRAINT `travel_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO travel_types VALUES('1','Corporation','','2020-07-27 09:21:23','2020-07-27 09:21:23');
INSERT INTO travel_types VALUES('2','Guest House','','2020-07-27 09:21:34','2020-07-27 09:21:34');
INSERT INTO travel_types VALUES('3','Hotel','','2020-07-27 09:21:39','2020-07-27 09:21:39');



CREATE TABLE `travels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `travel_type` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `purpose_of_visit` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `place_of_visit` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expected_budget` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actual_budget` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `travel_mode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travels_company_id_foreign` (`company_id`),
  KEY `travels_employee_id_foreign` (`employee_id`),
  KEY `travels_travel_type_foreign` (`travel_type`),
  CONSTRAINT `travels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_travel_type_foreign` FOREIGN KEY (`travel_type`) REFERENCES `travel_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO travels VALUES('2','bla bla bla','1','9','3','2021-03-18','2021-03-15','Rome','Athens','500','','By Plane','approved','2020-08-02 12:39:33','2020-08-18 12:43:03');
INSERT INTO travels VALUES('3','','1','9','1','2023-02-21','2023-02-22','Learning Tour','Sylhet','5000','5000','By Bus','approved','2023-02-09 10:06:17','2023-02-09 10:06:17');



CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_photo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_bg` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_users_id` bigint unsigned NOT NULL,
  `is_active` tinyint DEFAULT NULL,
  `contact_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_login_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_login_date` timestamp(2) NULL DEFAULT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `users_role_users_id_foreign` (`role_users_id`),
  CONSTRAINT `users_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Mister','Admin','admin','admin@gmail.com','','$2y$10$WcnC16AXG/mNrVBWQGjfoegFO.1wjiIiBv5LxEHR6uQaJYVciYCOa','admin_1722235144.jpg','','1','1','1234','136.232.139.38','2025-05-24 12:26:00.00','EGN51WxxCLhEUoqmNpDS6LtBa6IdB8Szpsmy53A51V8KTJ8p76D7f67AMttO','112073730973873758091','','2024-07-29 11:39:13','');
INSERT INTO users VALUES('9','Sahiba','Khatun','staff','irfanchowdhury434@gmail.com','','$2y$10$11HIbfvT3sIKJxBlInMYPuP4yV7IBCscMNY/XuLN.bt2/WLpg8zaW','staff_1616582111.jpg','','2','','387292822','127.0.0.1','2024-10-16 10:28:37.00','','112044537914775371858','2020-07-27 01:21:54','2025-05-17 14:22:13','');
INSERT INTO users VALUES('11','Neo','Dezhi','neo22','dezhi@gmail.com','','$2y$10$L8mI.pQwf9W3ijObnvBST.4bMF/G0AhwxAAwFgcOeytphQbLfExJi','','','6','','67278232','127.0.0.1','2023-10-02 13:02:19.00','','','2020-07-27 01:33:25','2025-05-17 14:20:28','');
INSERT INTO users VALUES('51','Lacey','Wood','gosofunab','myjof@mailinator.com','','$2y$10$WcnC16AXG/mNrVBWQGjfoegFO.1wjiIiBv5LxEHR6uQaJYVciYCOa','gosofunab_1648442766.jpg','','1','1','1211334234','127.0.0.1','2023-07-19 16:45:07.00','','','2022-03-28 10:16:07','2022-05-24 12:38:37','');
INSERT INTO users VALUES('59','Nitesh','Yadav','niteshyadav','developer@cbspd.com','','$2y$10$RE1DkxrywipHOAZS9Ws0jeorpV74WmMAo01NYTAJxHyK2iUDif0S.','developer_1747383332.png','','2','1','08467930685','223.177.191.19','2025-05-22 17:11:53.00','','','2025-05-16 13:45:32','2025-05-17 15:10:31','');



CREATE TABLE `warnings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` bigint unsigned NOT NULL,
  `warning_to` bigint unsigned NOT NULL,
  `warning_type` bigint unsigned DEFAULT NULL,
  `warning_date` date NOT NULL,
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warnings_company_id_foreign` (`company_id`),
  KEY `warnings_warning_to_foreign` (`warning_to`),
  KEY `warnings_warning_type_foreign` (`warning_type`),
  CONSTRAINT `warnings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_to_foreign` FOREIGN KEY (`warning_to`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_type_foreign` FOREIGN KEY (`warning_type`) REFERENCES `warnings_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO warnings VALUES('1','Harassment','Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.','1','11','1','2021-04-06','unsolved','2020-07-27 23:05:31','2020-07-27 23:05:31');



CREATE TABLE `warnings_type` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `warning_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO warnings_type VALUES('1','First written warning','2020-07-27 01:50:57','2020-07-27 01:50:57');
INSERT INTO warnings_type VALUES('2','Verbal Warning','2020-07-27 01:51:17','2020-07-27 01:51:17');

SET foreign_key_checks = 1;